/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin.saml;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class XMLErrorHandler
extends DefaultHandler {
    private static final Logger log = LoggerFactory.getLogger(XMLErrorHandler.class);
    protected static final Marker FATAL = MarkerFactory.getMarker((String)"FATAL");
    List<String> errorXML = new ArrayList<String>();

    XMLErrorHandler() {
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        this.errorXML.add("ERROR: " + e.getMessage());
        log.error("ERROR: " + e.getMessage());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.errorXML.add("FATALERROR: " + e.getMessage());
        log.error(FATAL, "FATALERROR: " + e.getMessage());
    }

    public List<String> getErrorXML() {
        return this.errorXML;
    }

    public void setErrorXML(List<String> errorXML) {
        this.errorXML = errorXML;
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.errorXML.add("WARNING: " + e.getMessage());
        log.warn("WARNING: " + e.getMessage());
    }
}

