/*
 * Decompiled with CFR 0.152.
 */
package com.onelogin;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.commons.codec.binary.Base64;

public class AccountSettings {
    private String certificate;
    private Certificate idp_cert;
    private String idp_sso_target_url;

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getIdp_sso_target_url() {
        return this.idp_sso_target_url;
    }

    public void setIdpSsoTargetUrl(String idp_sso_target_url) {
        this.idp_sso_target_url = idp_sso_target_url;
    }

    public void loadCertificate(String certificate) throws CertificateException {
        this.loadCertificate(certificate, true);
    }

    public void loadCertificate(String certificate, boolean isBase64) throws CertificateException {
        CertificateFactory fty = CertificateFactory.getInstance("X.509");
        byte[] cert = certificate.getBytes();
        if (isBase64) {
            cert = Base64.decodeBase64((byte[])cert);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(cert);
        this.idp_cert = fty.generateCertificate(bais);
    }

    public Certificate getIdpCert() throws CertificateException {
        if (this.idp_cert == null) {
            this.loadCertificate(this.certificate);
        }
        return this.idp_cert;
    }

    public Certificate getCert(byte[] certificate) throws CertificateException {
        CertificateFactory fty = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decodeBase64((byte[])certificate));
        this.idp_cert = fty.generateCertificate(bais);
        return this.idp_cert;
    }
}

