/*
 * Decompiled with CFR 0.152.
 */
package quickstart;

import com.okta.sdk.authc.credentials.ClientCredentials;
import com.okta.sdk.authc.credentials.TokenClientCredentials;
import com.okta.sdk.cache.Caches;
import com.okta.sdk.client.AuthorizationMode;
import com.okta.sdk.client.Client;
import com.okta.sdk.client.Clients;
import com.okta.sdk.resource.ExtensibleResource;
import com.okta.sdk.resource.Resource;
import com.okta.sdk.resource.application.Application;
import com.okta.sdk.resource.application.ApplicationList;
import com.okta.sdk.resource.application.SwaApplication;
import com.okta.sdk.resource.application.SwaApplicationSettings;
import com.okta.sdk.resource.application.SwaApplicationSettingsApplication;
import com.okta.sdk.resource.group.Group;
import com.okta.sdk.resource.group.GroupBuilder;
import com.okta.sdk.resource.group.GroupList;
import com.okta.sdk.resource.log.LogEventList;
import com.okta.sdk.resource.user.User;
import com.okta.sdk.resource.user.UserBuilder;
import com.okta.sdk.resource.user.UserList;
import com.okta.sdk.resource.user.factor.ActivateFactorRequest;
import com.okta.sdk.resource.user.factor.SmsUserFactor;
import com.okta.sdk.resource.user.factor.UserFactor;
import com.okta.sdk.resource.user.factor.UserFactorList;
import com.okta.sdk.resource.user.factor.VerifyFactorRequest;
import com.okta.sdk.resource.user.factor.VerifyUserFactorResponse;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadmeSnippets {
    private static final Logger log = LoggerFactory.getLogger(ReadmeSnippets.class);
    private final Client client = Clients.builder().build();
    private final User user = null;

    private void createClient() {
        Client client = Clients.builder().setOrgUrl("https://{yourOktaDomain}").setClientCredentials((ClientCredentials)new TokenClientCredentials("{apiToken}")).build();
    }

    private void isClientReady() {
        boolean isClientReadyStatus = this.client.isReady(() -> ((Client)this.client).listApplications());
    }

    private void createOAuth2Client() {
        Client client = Clients.builder().setOrgUrl("https://{yourOktaDomain}").setAuthorizationMode(AuthorizationMode.PRIVATE_KEY).setClientId("{clientId}").setKid("{kid}").setScopes(new HashSet<String>(Arrays.asList("okta.users.read", "okta.apps.read"))).setPrivateKey("/path/to/yourPrivateKey.pem").build();
    }

    private void getUser() {
        User user = this.client.getUser("a-user-id");
    }

    private void listAllUsers() {
        UserList users = this.client.listUsers();
        this.client.listUsers().stream().forEach(user -> {});
    }

    private void userSearch() {
        UserList users = this.client.listUsers("jcoder@example.com", null, null, null, null);
        users = this.client.listUsers(null, "status eq \"ACTIVE\"", null, null, null);
    }

    private void createUser() {
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").buildAndCreate(this.client);
    }

    private void createUserWithGroups() {
        User user = UserBuilder.instance().setEmail("joe.coder@example.com").setFirstName("Joe").setLastName("Code").setGroups(new HashSet<String>(Arrays.asList("group-id-1", "group-id-2"))).buildAndCreate(this.client);
    }

    private void updateUser() {
        this.user.getProfile().setFirstName("new-first-name");
        this.user.update();
    }

    private void customAttributes() {
        this.user.getProfile().put((Object)"customPropertyKey", (Object)"a value");
        this.user.getProfile().get((Object)"customPropertyKey");
    }

    private void deleteUser() {
        this.user.deactivate();
        this.user.delete();
    }

    private void listUsersGroup() {
        GroupList groups = this.user.listGroups();
    }

    private void createGroup() {
        Group group = GroupBuilder.instance().setName("a-group-name").setDescription("Example Group").buildAndCreate(this.client);
    }

    private void addUserToGroup() {
        this.user.addToGroup("groupId");
    }

    private void listUserFactors() {
        UserFactorList factors = this.user.listFactors();
    }

    private void enrollUserInFactor() {
        SmsUserFactor smsFactor = (SmsUserFactor)this.client.instantiate(SmsUserFactor.class);
        smsFactor.getProfile().setPhoneNumber("555 867 5309");
        this.user.enrollFactor((UserFactor)smsFactor);
    }

    private void activateFactor() {
        UserFactor factor = this.user.getFactor("factorId");
        ActivateFactorRequest activateFactorRequest = (ActivateFactorRequest)this.client.instantiate(ActivateFactorRequest.class);
        activateFactorRequest.setPassCode("123456");
        factor.activate(activateFactorRequest);
    }

    private void verifyFactor() {
        UserFactor factor = this.user.getFactor("factorId");
        VerifyFactorRequest verifyFactorRequest = (VerifyFactorRequest)this.client.instantiate(VerifyFactorRequest.class);
        verifyFactorRequest.setPassCode("123456");
        VerifyUserFactorResponse verifyUserFactorResponse = factor.setVerify(verifyFactorRequest).verify();
    }

    private void listApplication() {
        ApplicationList applications = this.client.listApplications();
    }

    private void getApplication() {
        Application app = this.client.getApplication("appId");
    }

    private void createSwaApplication() {
        SwaApplication swaApp = ((SwaApplication)this.client.instantiate(SwaApplication.class)).setSettings(((SwaApplicationSettings)this.client.instantiate(SwaApplicationSettings.class)).setApp(((SwaApplicationSettingsApplication)this.client.instantiate(SwaApplicationSettingsApplication.class)).setButtonField("btn-login").setPasswordField("txtbox-password").setUsernameField("txtbox-username").setUrl("https://example.com/login.html")));
    }

    private void listSysLogs() {
        LogEventList logEvents = this.client.getLogs();
        logEvents = this.client.getLogs(null, null, null, "interestingURI.com", "ASCENDING");
    }

    private void callAnotherEndpoint() {
        ExtensibleResource resource = (ExtensibleResource)this.client.instantiate(ExtensibleResource.class);
        ExtensibleResource protocolNode = (ExtensibleResource)this.client.instantiate(ExtensibleResource.class);
        protocolNode.put((Object)"type", (Object)"OAUTH");
        resource.put((Object)"protocol", (Object)protocolNode);
        ExtensibleResource result = (ExtensibleResource)this.client.http().setBody((Resource)resource).post("/api/v1/idps", ExtensibleResource.class);
    }

    private void paging() {
        UserList users = this.client.listUsers();
        log.info("First user in collection: {}", (Object)((User)users.iterator().next()).getProfile().getEmail());
        for (User tmpUser2 : users) {
            log.info("User: {}", (Object)tmpUser2.getProfile().getEmail());
        }
        users.stream().forEach(tmpUser -> log.info("User: {}", (Object)tmpUser.getProfile().getEmail()));
    }

    private void complexCaching() {
        Caches.newCacheManager().withDefaultTimeToLive(300L, TimeUnit.SECONDS).withDefaultTimeToIdle(300L, TimeUnit.SECONDS).withCache(Caches.forResource(User.class).withTimeToLive(1L, TimeUnit.HOURS).withTimeToIdle(30L, TimeUnit.MINUTES)).withCache(Caches.forResource(Group.class).withTimeToLive(2L, TimeUnit.HOURS)).build();
    }

    private void disableCaching() {
        Client client = Clients.builder().setCacheManager(Caches.newDisabledCacheManager()).build();
    }
}

