/*
 * Decompiled with CFR 0.152.
 */
package com.okta.idx.sdk.api.client;

import com.okta.idx.sdk.api.client.WrapperUtil;
import com.okta.idx.sdk.api.model.IDXClientContext;
import com.okta.idx.sdk.api.model.PollInfo;
import com.okta.idx.sdk.api.model.Remediation;
import com.okta.idx.sdk.api.model.RemediationOption;
import com.okta.idx.sdk.api.response.IDXResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public final class ProceedContext {
    private final IDXClientContext clientContext;
    private final String stateHandle;
    private final String href;
    private final String skipHref;
    private final boolean isIdentifyInOneStep;
    private final String selectProfileEnrollHref;
    private final String resendHref;
    private final PollInfo pollInfo;
    private final Duration refresh;
    private final IDXResponse idxResponse;

    ProceedContext(IDXClientContext clientContext, String stateHandle, String href, String skipHref, boolean isIdentifyInOneStep, String selectProfileEnrollHref, String resendHref, PollInfo pollInfo, Duration refresh, IDXResponse idxResponse) {
        this.clientContext = clientContext;
        this.stateHandle = stateHandle;
        this.href = href;
        this.skipHref = skipHref;
        this.isIdentifyInOneStep = isIdentifyInOneStep;
        this.selectProfileEnrollHref = selectProfileEnrollHref;
        this.resendHref = resendHref;
        this.pollInfo = pollInfo;
        this.refresh = refresh;
        this.idxResponse = idxResponse;
    }

    public IDXClientContext getClientContext() {
        return this.clientContext;
    }

    String getStateHandle() {
        RemediationOption remediationOption;
        String remediationStateHandle;
        if (this.idxResponse == null) {
            return this.stateHandle;
        }
        Remediation remediation = this.idxResponse.remediation();
        if (remediation != null && remediation.remediationOptions() != null && remediation.remediationOptions().size() > 0 && (remediationStateHandle = WrapperUtil.getStateHandle((remediationOption = remediation.remediationOptions().get(0)).form())) != null) {
            return remediationStateHandle;
        }
        return this.stateHandle;
    }

    String getHref() {
        return this.href;
    }

    String getSkipHref() {
        return this.skipHref;
    }

    boolean isIdentifyInOneStep() {
        return this.isIdentifyInOneStep;
    }

    String getSelectProfileEnrollHref() {
        return this.selectProfileEnrollHref;
    }

    public String getResendHref() {
        return this.resendHref;
    }

    public PollInfo getPollInfo() {
        return this.pollInfo;
    }

    public Duration getRefresh() {
        return this.refresh != null ? Duration.of(this.refresh.getSeconds(), ChronoUnit.MILLIS) : null;
    }

    public boolean isIdentifierFirstFlow() {
        return !this.isIdentifyInOneStep();
    }

    IDXResponse getIdxResponse() {
        return this.idxResponse;
    }
}

