/*
 * Decompiled with CFR 0.152.
 */
package com.ogaclejapan.smarttablayout.utils.v4;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.collection.SparseArrayCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;
import com.ogaclejapan.smarttablayout.utils.v4.FragmentPagerItem;
import com.ogaclejapan.smarttablayout.utils.v4.FragmentPagerItems;
import java.lang.ref.WeakReference;

public class FragmentPagerItemAdapter
extends FragmentPagerAdapter {
    private final FragmentPagerItems pages;
    private final SparseArrayCompat<WeakReference<Fragment>> holder;

    public FragmentPagerItemAdapter(FragmentManager fm, FragmentPagerItems pages) {
        super(fm);
        this.pages = pages;
        this.holder = new SparseArrayCompat(pages.size());
    }

    public int getCount() {
        return this.pages.size();
    }

    public Fragment getItem(int position) {
        return this.getPagerItem(position).instantiate(this.pages.getContext(), position);
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        Object item = super.instantiateItem(container, position);
        if (item instanceof Fragment) {
            this.holder.put(position, new WeakReference<Fragment>((Fragment)item));
        }
        return item;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        this.holder.remove(position);
        super.destroyItem(container, position, object);
    }

    public CharSequence getPageTitle(int position) {
        return this.getPagerItem(position).getTitle();
    }

    public float getPageWidth(int position) {
        return super.getPageWidth(position);
    }

    public Fragment getPage(int position) {
        WeakReference weakRefItem = (WeakReference)this.holder.get(position);
        return weakRefItem != null ? (Fragment)weakRefItem.get() : null;
    }

    protected FragmentPagerItem getPagerItem(int position) {
        return (FragmentPagerItem)this.pages.get(position);
    }
}

