/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.protocol;

import com.ftdi.j2xx.interfaces.SpiSlave;
import com.ftdi.j2xx.protocol.SpiSlaveEvent;
import com.ftdi.j2xx.protocol.SpiSlaveListener;
import com.ftdi.j2xx.protocol.SpiSlaveRequestEvent;
import com.ftdi.j2xx.protocol.SpiSlaveResponseEvent;
import com.ftdi.j2xx.protocol.SpiSlaveThread;
import junit.framework.Assert;

public class FT_Spi_Slave
extends SpiSlaveThread {
    private static final int FT4222_SPI_SLAVE_SYNC_WORD = 90;
    private static final int SPI_MASTER_TRANSFER = 128;
    private static final int SPI_SLAVE_TRANSFER = 129;
    private static final int SPI_SHORT_MASTER_TRANSFER = 130;
    private static final int SPI_SHART_SLAVE_TRANSFER = 131;
    private static final int SPI_ACK = 132;
    private static final int SPI_QUERY_VER = 136;
    private DECODE_STATE mDecodeState;
    private int mSync;
    private int mCmd;
    private int mSn;
    private int mBufferSize;
    private int mCurrentBufferSize;
    private byte[] mBuffer;
    private int mCheckSum;
    private int mWrSn;
    private SpiSlave mSpiSlave;
    private SpiSlaveListener mSpiSlaveListener;
    private boolean mIsOpened;

    public FT_Spi_Slave(SpiSlave pSlaveInterface) {
        this.mSpiSlave = pSlaveInterface;
        this.mDecodeState = DECODE_STATE.STATE_SYNC;
    }

    public void registerSpiSlaveListener(SpiSlaveListener pListener) {
        this.mSpiSlaveListener = pListener;
    }

    public int open() {
        if (this.mIsOpened) {
            return 1;
        }
        this.mIsOpened = true;
        this.mSpiSlave.init();
        this.start();
        return 0;
    }

    public int close() {
        if (!this.mIsOpened) {
            return 3;
        }
        SpiSlaveRequestEvent event = new SpiSlaveRequestEvent(-1, true, null, null, null);
        this.sendMessage(event);
        this.mIsOpened = false;
        return 0;
    }

    public int write(byte[] wrBuf) {
        if (!this.mIsOpened) {
            return 3;
        }
        if (wrBuf.length > 65536) {
            return 1010;
        }
        int[] sizeTransferred = new int[1];
        int idx = 0;
        int wrSize = wrBuf.length;
        int checksum = this.getCheckSum(wrBuf, 90, 129, this.mWrSn, wrSize);
        byte[] buffer = new byte[8 + wrBuf.length];
        buffer[idx++] = 0;
        buffer[idx++] = 90;
        buffer[idx++] = -127;
        buffer[idx++] = (byte)this.mWrSn;
        buffer[idx++] = (byte)((wrSize & 0xFF00) >> 8);
        buffer[idx++] = (byte)(wrSize & 0xFF);
        int i = 0;
        while (i < wrBuf.length) {
            buffer[idx++] = wrBuf[i];
            ++i;
        }
        buffer[idx++] = (byte)((checksum & 0xFF00) >> 8);
        buffer[idx++] = (byte)(checksum & 0xFF);
        this.mSpiSlave.write(buffer, buffer.length, sizeTransferred);
        if (sizeTransferred[0] != buffer.length) {
            return 4;
        }
        ++this.mWrSn;
        if (this.mWrSn >= 256) {
            this.mWrSn = 0;
        }
        return 0;
    }

    private boolean check_valid_spi_cmd(int cmd) {
        return cmd == 128 || cmd == 130 || cmd == 136;
    }

    private int getCheckSum(byte[] sendBuf, int sync, int cmd, int sn, int bufsize) {
        int sum = 0;
        if (sendBuf != null) {
            int idx = 0;
            while (idx < sendBuf.length) {
                sum += sendBuf[idx] & 0xFF;
                ++idx;
            }
        }
        sum += sync;
        sum += cmd;
        sum += sn;
        sum += (bufsize & 0xFF00) >> 8;
        return sum += bufsize & 0xFF;
    }

    private void spi_push_req_ack_queue() {
        int idx = 0;
        byte[] buffer = new byte[8];
        buffer[idx++] = 0;
        buffer[idx++] = 90;
        buffer[idx++] = -124;
        buffer[idx++] = (byte)this.mSn;
        buffer[idx++] = 0;
        buffer[idx++] = 0;
        int checksum = this.getCheckSum(null, 90, 132, this.mSn, 0);
        buffer[idx++] = (byte)((checksum & 0xFF00) >> 8);
        buffer[idx++] = (byte)(checksum & 0xFF);
        int[] sizeTransferred = new int[1];
        this.mSpiSlave.write(buffer, buffer.length, sizeTransferred);
    }

    private void sp_slave_parse_and_push_queue(byte[] rdBuf) {
        boolean reset = false;
        boolean dataCorrupted = false;
        int i = 0;
        while (i < rdBuf.length) {
            int val = rdBuf[i] & 0xFF;
            switch (this.mDecodeState) {
                case STATE_SYNC: {
                    if (val != 90) {
                        reset = true;
                        break;
                    }
                    this.mDecodeState = DECODE_STATE.STATE_CMD;
                    this.mSync = val;
                    break;
                }
                case STATE_CMD: {
                    if (!this.check_valid_spi_cmd(val)) {
                        reset = true;
                        dataCorrupted = true;
                    } else {
                        this.mCmd = val;
                    }
                    this.mDecodeState = DECODE_STATE.STATE_SN;
                    break;
                }
                case STATE_SN: {
                    this.mSn = val;
                    this.mDecodeState = DECODE_STATE.STATE_SIZE_HIGH;
                    break;
                }
                case STATE_SIZE_HIGH: {
                    this.mBufferSize = val * 256;
                    this.mDecodeState = DECODE_STATE.STATE_SIZE_LOW;
                    break;
                }
                case STATE_SIZE_LOW: {
                    this.mBufferSize += val;
                    this.mCurrentBufferSize = 0;
                    this.mBuffer = new byte[this.mBufferSize];
                    this.mDecodeState = DECODE_STATE.STATE_COLLECT_DATA;
                    break;
                }
                case STATE_COLLECT_DATA: {
                    this.mBuffer[this.mCurrentBufferSize] = rdBuf[i];
                    ++this.mCurrentBufferSize;
                    if (this.mCurrentBufferSize != this.mBufferSize) break;
                    this.mDecodeState = DECODE_STATE.STATE_CHECKSUM_HIGH;
                    break;
                }
                case STATE_CHECKSUM_HIGH: {
                    this.mCheckSum = val * 256;
                    this.mDecodeState = DECODE_STATE.STATE_CHECKSUM_LOW;
                    break;
                }
                case STATE_CHECKSUM_LOW: {
                    this.mCheckSum += val;
                    int dataCheckSum = this.getCheckSum(this.mBuffer, this.mSync, this.mCmd, this.mSn, this.mBufferSize);
                    if (this.mCheckSum == dataCheckSum) {
                        if (this.mCmd == 128) {
                            this.spi_push_req_ack_queue();
                            if (this.mSpiSlaveListener != null) {
                                SpiSlaveResponseEvent pEvent = new SpiSlaveResponseEvent(3, 0, (Object)this.mBuffer, null, null);
                                this.mSpiSlaveListener.OnDataReceived(pEvent);
                            }
                        }
                    } else {
                        dataCorrupted = true;
                    }
                    reset = true;
                }
            }
            if (dataCorrupted && this.mSpiSlaveListener != null) {
                SpiSlaveResponseEvent pEvent = new SpiSlaveResponseEvent(3, 1, null, null, null);
                this.mSpiSlaveListener.OnDataReceived(pEvent);
            }
            if (reset) {
                this.mDecodeState = DECODE_STATE.STATE_SYNC;
                this.mSync = 0;
                this.mCmd = 0;
                this.mSn = 0;
                this.mBufferSize = 0;
                this.mCurrentBufferSize = 0;
                this.mCheckSum = 0;
                this.mBuffer = null;
                reset = false;
                dataCorrupted = false;
            }
            ++i;
        }
    }

    protected boolean pollData() {
        byte[] rdBuf;
        int status = 0;
        int[] rxSize = new int[1];
        status = this.mSpiSlave.getRxStatus(rxSize);
        if (rxSize[0] > 0 && status == 0 && (status = this.mSpiSlave.read(rdBuf = new byte[rxSize[0]], rdBuf.length, rxSize)) == 0) {
            this.sp_slave_parse_and_push_queue(rdBuf);
        }
        if (status == 4 && this.mSpiSlaveListener != null) {
            SpiSlaveResponseEvent pEvent = new SpiSlaveResponseEvent(3, 2, (Object)this.mBuffer, null, null);
            this.mSpiSlaveListener.OnDataReceived(pEvent);
        }
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    protected void requestEvent(SpiSlaveEvent pEvent) {
        if (pEvent instanceof SpiSlaveRequestEvent) {
            Object responseEvent = null;
            switch (pEvent.getEventType()) {
                case -1: {
                    break;
                }
            }
        } else {
            Assert.assertTrue((String)("processEvent wrong type" + pEvent.getEventType()), (boolean)false);
        }
    }

    protected boolean isTerminateEvent(SpiSlaveEvent pEvent) {
        if (!Thread.interrupted()) {
            return true;
        }
        if (pEvent instanceof SpiSlaveRequestEvent) {
            switch (pEvent.getEventType()) {
                case -1: {
                    return true;
                }
            }
        } else {
            Assert.assertTrue((String)("processEvent wrong type" + pEvent.getEventType()), (boolean)false);
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DECODE_STATE {
        STATE_SYNC,
        STATE_CMD,
        STATE_SN,
        STATE_SIZE_HIGH,
        STATE_SIZE_LOW,
        STATE_COLLECT_DATA,
        STATE_CHECKSUM_HIGH,
        STATE_CHECKSUM_LOW;

    }
}

