/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.ft4222;

import android.util.Log;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.ft4222.FT_4222_Device;
import com.ftdi.j2xx.ft4222.SPI_MasterCfg;
import com.ftdi.j2xx.ft4222.chiptop_mgr;
import com.ftdi.j2xx.interfaces.SpiMaster;
import junit.framework.Assert;

public class FT_4222_Spi_Master
implements SpiMaster {
    private FT_4222_Device mFT4222Device;
    private FT_Device mFTDevice;
    private static final String TAG = "FTDI_Device::";

    public FT_4222_Spi_Master(FT_4222_Device pDevice) {
        this.mFT4222Device = pDevice;
        this.mFTDevice = pDevice.mFtDev;
    }

    public int init(int ioLine, int clock, int cpol, int cpha, byte ssoMap) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        int venderSSOMap = 0;
        SPI_MasterCfg config = this.mFT4222Device.mSpiMasterCfg;
        config.ioLine = ioLine;
        config.clock = clock;
        config.cpol = cpol;
        config.cpha = cpha;
        config.ssoMap = ssoMap;
        if (config.ioLine != 1 && config.ioLine != 2 && config.ioLine != 4) {
            return 6;
        }
        this.mFT4222Device.cleanRxData();
        switch (chipStatus.chip_mode) {
            case 0: {
                venderSSOMap = 1;
                break;
            }
            case 1: {
                venderSSOMap = 7;
                break;
            }
            case 2: {
                venderSSOMap = 15;
                break;
            }
            case 3: {
                venderSSOMap = 1;
            }
        }
        if ((venderSSOMap & config.ssoMap) == 0) {
            return 6;
        }
        config.ssoMap = (byte)(config.ssoMap & venderSSOMap);
        int venderSS = 0;
        int verderFun = 3;
        if (this.mFTDevice.VendorCmdSet(33, 0x42 | config.ioLine << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x44 | config.clock << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x45 | config.cpol << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x46 | config.cpha << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x43 | venderSS << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x48 | config.ssoMap << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 5 | verderFun << 8) < 0) {
            return 4;
        }
        chipStatus.function = (byte)3;
        return 0;
    }

    public int setLines(int spiMode) {
        int verderRestart = 1;
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        if (chipStatus.function != 3) {
            return 1003;
        }
        if (spiMode == 0) {
            return 17;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x42 | spiMode << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 0x4A | verderRestart << 8) < 0) {
            return 4;
        }
        SPI_MasterCfg spiCfg = this.mFT4222Device.mSpiMasterCfg;
        spiCfg.ioLine = spiMode;
        return 0;
    }

    public int singleWrite(byte[] writeBuffer, int sizeToTransfer, int[] sizeTransferred, boolean isEndTransaction) {
        byte[] readBuffer = new byte[writeBuffer.length];
        return this.singleReadWrite(readBuffer, writeBuffer, sizeToTransfer, sizeTransferred, isEndTransaction);
    }

    public int singleRead(byte[] readBuffer, int sizeToTransfer, int[] sizeOfRead, boolean isEndTransaction) {
        byte[] writeBuffer = new byte[readBuffer.length];
        return this.singleReadWrite(readBuffer, writeBuffer, sizeToTransfer, sizeOfRead, isEndTransaction);
    }

    public int singleReadWrite(byte[] readBuffer, byte[] writeBuffer, int sizeToTransfer, int[] sizeTransferred, boolean isEndTransaction) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        SPI_MasterCfg spiCfg = this.mFT4222Device.mSpiMasterCfg;
        if (writeBuffer == null || readBuffer == null || sizeTransferred == null) {
            return 1009;
        }
        sizeTransferred[0] = 0;
        if (chipStatus.function != 3 || spiCfg.ioLine != 1) {
            return 1005;
        }
        if (sizeToTransfer == 0) {
            return 6;
        }
        if (sizeToTransfer > writeBuffer.length || sizeToTransfer > readBuffer.length) {
            Assert.assertTrue((String)"sizeToTransfer > writeBuffer.length || sizeToTransfer > readBuffer.length", (boolean)false);
        }
        if (writeBuffer.length != readBuffer.length || writeBuffer.length == 0) {
            Assert.assertTrue((String)"writeBuffer.length != readBuffer.length || writeBuffer.length == 0", (boolean)false);
        }
        sizeTransferred[0] = this.sendReadWriteBuffer(this.mFTDevice, writeBuffer, readBuffer, sizeToTransfer);
        if (isEndTransaction) {
            this.mFTDevice.write(null, 0);
        }
        return 0;
    }

    public int multiReadWrite(byte[] readBuffer, byte[] writeBuffer, int singleWriteBytes, int multiWriteBytes, int multiReadBytes, int[] sizeOfRead) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        SPI_MasterCfg spiCfg = this.mFT4222Device.mSpiMasterCfg;
        if (multiReadBytes > 0 && readBuffer == null) {
            return 1009;
        }
        if (singleWriteBytes + multiWriteBytes > 0 && writeBuffer == null) {
            return 1009;
        }
        if (multiReadBytes > 0 && sizeOfRead == null) {
            return 1009;
        }
        if (chipStatus.function != 3 || spiCfg.ioLine == 1) {
            return 1006;
        }
        if (singleWriteBytes > 15) {
            Log.e((String)TAG, (String)"The maxium single write bytes are 15 bytes");
            return 6;
        }
        int sendDataSize = 5 + singleWriteBytes + multiWriteBytes;
        byte[] sendData = new byte[sendDataSize];
        sendData[0] = (byte)(0x80 | singleWriteBytes & 0xF);
        sendData[1] = (byte)((multiWriteBytes & 0xFF00) >> 8);
        sendData[2] = (byte)(multiWriteBytes & 0xFF);
        sendData[3] = (byte)((multiReadBytes & 0xFF00) >> 8);
        sendData[4] = (byte)(multiReadBytes & 0xFF);
        int i = 0;
        while (i < singleWriteBytes + multiWriteBytes) {
            sendData[i + 5] = writeBuffer[i];
            ++i;
        }
        sizeOfRead[0] = this.setMultiReadWritePackage(this.mFTDevice, sendData, readBuffer);
        return 0;
    }

    public int reset() {
        int verderReset = 0;
        if (this.mFTDevice.VendorCmdSet(33, 0x4A | verderReset << 8) < 0) {
            return 4;
        }
        return 0;
    }

    public int setDrivingStrength(int clkStrength, int ioStrength, int ssoStregth) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        if (chipStatus.function != 3 && chipStatus.function != 4) {
            return 1003;
        }
        int actual_strength = clkStrength << 4;
        actual_strength |= ioStrength << 2;
        int verderFun = chipStatus.function == 3 ? 3 : 4;
        if (this.mFTDevice.VendorCmdSet(33, 0xA0 | (actual_strength |= ssoStregth) << 8) < 0) {
            return 4;
        }
        if (this.mFTDevice.VendorCmdSet(33, 5 | verderFun << 8) < 0) {
            return 4;
        }
        return 0;
    }

    private int setMultiReadWritePackage(FT_Device ftSPIDevice, byte[] wr_buffer, byte[] rd_buffer) {
        int ret = 0;
        int sleepCnt = 0;
        int sleepTime = 10;
        int maxWaitTime = 30000;
        int bytesRead = 0;
        if (ftSPIDevice == null || !ftSPIDevice.isOpen()) {
            return -1;
        }
        ret = ftSPIDevice.write(wr_buffer, wr_buffer.length);
        while (bytesRead < rd_buffer.length && sleepCnt < maxWaitTime) {
            ret = ftSPIDevice.getQueueStatus();
            if (ret > 0) {
                sleepCnt = 0;
                byte[] rd_tmp_buf = new byte[ret];
                Assert.assertEquals((rd_tmp_buf.length == (ret = ftSPIDevice.read(rd_tmp_buf, ret)) ? 1 : 0) != 0, (boolean)true);
                int i = 0;
                while (i < rd_tmp_buf.length) {
                    if (bytesRead + i < rd_buffer.length) {
                        rd_buffer[bytesRead + i] = rd_tmp_buf[i];
                    }
                    ++i;
                }
                bytesRead += ret;
            }
            try {
                Thread.sleep(sleepTime);
                sleepCnt += sleepTime;
            }
            catch (InterruptedException e) {
                sleepCnt = maxWaitTime;
            }
        }
        if (rd_buffer.length != bytesRead || sleepCnt > maxWaitTime) {
            Log.e((String)TAG, (String)"MultiReadWritePackage timeout!!!!");
            return -1;
        }
        return bytesRead;
    }

    private int sendReadWriteBuffer(FT_Device ftDevice, byte[] wr_buffer, byte[] rd_buffer, int sizeToTransfer) {
        byte[] wrPackBuf = new byte[16384];
        byte[] rdPackBuf = new byte[wrPackBuf.length];
        int packCount = sizeToTransfer / wrPackBuf.length;
        int restCount = sizeToTransfer % wrPackBuf.length;
        int readIdx = 0;
        int writeIdx = 0;
        int valRet = 0;
        int i = 0;
        while (i < packCount) {
            int j = 0;
            while (j < wrPackBuf.length) {
                wrPackBuf[j] = wr_buffer[writeIdx];
                ++writeIdx;
                ++j;
            }
            valRet = this.setReadWritePackage(ftDevice, wrPackBuf, rdPackBuf);
            if (valRet <= 0) {
                return -1;
            }
            j = 0;
            while (j < rdPackBuf.length) {
                rd_buffer[readIdx] = rdPackBuf[j];
                ++readIdx;
                ++j;
            }
            ++i;
        }
        if (restCount > 0) {
            wrPackBuf = new byte[restCount];
            rdPackBuf = new byte[wrPackBuf.length];
            int j = 0;
            while (j < wrPackBuf.length) {
                wrPackBuf[j] = wr_buffer[writeIdx];
                ++writeIdx;
                ++j;
            }
            valRet = this.setReadWritePackage(ftDevice, wrPackBuf, rdPackBuf);
            if (valRet <= 0) {
                return -1;
            }
            j = 0;
            while (j < rdPackBuf.length) {
                rd_buffer[readIdx] = rdPackBuf[j];
                ++readIdx;
                ++j;
            }
        }
        return readIdx;
    }

    /*
     * Unable to fully structure code
     */
    private int setReadWritePackage(FT_Device ftSPIDevice, byte[] wr_buffer, byte[] rd_buffer) {
        ret = 0;
        sleepCnt = 0;
        sleepTime = 10;
        maxWaitTime = 30000;
        bytesRead = 0;
        if (ftSPIDevice == null || !ftSPIDevice.isOpen()) {
            return -1;
        }
        Assert.assertEquals((boolean)(wr_buffer.length == rd_buffer.length), (boolean)true);
        ret = ftSPIDevice.write(wr_buffer, wr_buffer.length);
        if (wr_buffer.length == ret) ** GOTO lbl32
        Log.e((String)"FTDI_Device::", (String)"setReadWritePackage Incomplete Write Error!!!");
        return -1;
lbl-1000:
        // 1 sources

        {
            ret = ftSPIDevice.getQueueStatus();
            if (ret > 0) {
                sleepCnt = 0;
                rd_tmp_buf = new byte[ret];
                Assert.assertEquals((boolean)(rd_tmp_buf.length == (ret = ftSPIDevice.read(rd_tmp_buf, ret))), (boolean)true);
                i = 0;
                while (i < rd_tmp_buf.length) {
                    if (bytesRead + i < rd_buffer.length) {
                        rd_buffer[bytesRead + i] = rd_tmp_buf[i];
                    }
                    ++i;
                }
                bytesRead += ret;
            }
            try {
                Thread.sleep(sleepTime);
                sleepCnt += sleepTime;
                continue;
            }
            catch (InterruptedException e) {
                sleepCnt = maxWaitTime;
            }
lbl32:
            // 3 sources

            ** while (bytesRead < rd_buffer.length && sleepCnt < maxWaitTime)
        }
lbl33:
        // 1 sources

        if (rd_buffer.length != bytesRead || sleepCnt > maxWaitTime) {
            Log.e((String)"FTDI_Device::", (String)"SingleReadWritePackage timeout!!!!");
            return -1;
        }
        return bytesRead;
    }
}

