/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx.ft4222;

import android.util.Log;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.ft4222.FT_4222_Device;
import com.ftdi.j2xx.ft4222.chiptop_mgr;
import com.ftdi.j2xx.ft4222.gpio_dev;
import com.ftdi.j2xx.ft4222.gpio_mgr;
import com.ftdi.j2xx.interfaces.Gpio;

public class FT_4222_Gpio
implements Gpio {
    private FT_4222_Device mFT4222Device;
    private FT_Device mFtDev;
    static final int TOTAL_GPIOS = 4;
    boolean iSignal = true;
    static final int GET_STATUS = 32;
    static final int SET_DIRECTION = 33;
    static final int GET_DIRECTION = 33;
    static final int SET_PULL_UP = 34;
    static final int GET_PULL_UP = 34;
    static final int SET_OPEN_DRAIN = 35;
    static final int GET_OPEN_DRAIN = 35;
    static final int SET_PULL_DOWN = 36;
    static final int GET_PULL_DOWN = 36;

    public FT_4222_Gpio(FT_4222_Device ft4222Device) {
        this.mFT4222Device = ft4222Device;
        this.mFtDev = this.mFT4222Device.mFtDev;
    }

    public int cmdSet(int wValue1, int wValue2) {
        return this.mFtDev.VendorCmdSet(33, wValue1 | wValue2 << 8);
    }

    public int cmdSet(int wValue1, int wValue2, byte[] buf, int datalen) {
        return this.mFtDev.VendorCmdSet(33, wValue1 | wValue2 << 8, buf, datalen);
    }

    public int cmdGet(int wValue1, int wValue2, byte[] buf, int datalen) {
        return this.mFtDev.VendorCmdGet(32, wValue1 | wValue2 << 8, buf, datalen);
    }

    public int init(int[] gpio) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        gpio_dev gpioStatus = new gpio_dev();
        byte[] data = new byte[1];
        gpio_mgr gpioMgr = new gpio_mgr();
        this.cmdSet(7, 0);
        this.cmdSet(6, 0);
        int ftStatus = this.mFT4222Device.init();
        if (ftStatus != 0) {
            Log.e((String)"GPIO_M", (String)("FT4222_GPIO init - 1 NG ftStatus:" + ftStatus));
            return ftStatus;
        }
        if (chipStatus.chip_mode == 2 || chipStatus.chip_mode == 3) {
            return 1013;
        }
        this.getStatus(gpioStatus);
        byte dir = gpioStatus.dir;
        data[0] = gpioStatus.dat[0];
        int idx = 0;
        while (idx < 4) {
            dir = gpio[idx] == 1 ? (byte)((dir | 1 << idx) & 0xF) : (byte)(dir & ~(1 << idx) & 0xF);
            ++idx;
        }
        gpioMgr.lastGpioData = data[0];
        this.cmdSet(33, dir);
        return 0;
    }

    public int read(int portNum, boolean[] bValue) {
        gpio_dev gpioStatus = new gpio_dev();
        int ftStatus = this.check(portNum);
        if (ftStatus != 0) {
            return ftStatus;
        }
        ftStatus = this.getStatus(gpioStatus);
        if (ftStatus != 0) {
            return ftStatus;
        }
        this.getGpioPinLevel(portNum, gpioStatus.dat[0], bValue);
        return 0;
    }

    public int newRead(int portNum, boolean[] bValue) {
        int ftStatus = this.check(portNum);
        if (ftStatus != 0) {
            return ftStatus;
        }
        int iSize = this.mFtDev.getQueueStatus();
        if (iSize <= 0) {
            return -1;
        }
        byte[] bData = new byte[iSize];
        this.mFtDev.read(bData, iSize);
        this.getGpioPinLevel(portNum, bData[iSize - 1], bValue);
        return iSize;
    }

    public int write(int portNum, boolean bValue) {
        gpio_dev gpioStatus = new gpio_dev();
        int ftStatus = this.check(portNum);
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (!this.is_GPIOPort_Valid_Output(portNum)) {
            return 1015;
        }
        this.getStatus(gpioStatus);
        gpioStatus.dat[0] = bValue ? (byte)(gpioStatus.dat[0] | 1 << portNum) : (byte)(gpioStatus.dat[0] & (~(1 << portNum) & 0xF));
        int status = this.mFtDev.write(gpioStatus.dat, 1);
        return status;
    }

    public int newWrite(int portNum, boolean bValue) {
        gpio_dev gpioStatus = new gpio_dev();
        int ftStatus = this.check(portNum);
        if (ftStatus != 0) {
            return ftStatus;
        }
        if (!this.is_GPIOPort_Valid_Output(portNum)) {
            return 1015;
        }
        this.getStatus(gpioStatus);
        gpioStatus.dat[0] = bValue ? (byte)(gpioStatus.dat[0] | 1 << portNum) : (byte)(gpioStatus.dat[0] & (~(1 << portNum) & 0xF));
        gpioStatus.dat[0] = this.iSignal ? (byte)(gpioStatus.dat[0] | 8) : (byte)(gpioStatus.dat[0] & 7);
        int status = this.mFtDev.write(gpioStatus.dat, 1);
        this.iSignal = !this.iSignal;
        return status;
    }

    int check(int portNum) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        if (chipStatus.chip_mode == 2 || chipStatus.chip_mode == 3) {
            return 1013;
        }
        if (portNum >= 4) {
            return 1014;
        }
        return 0;
    }

    int getStatus(gpio_dev gpioStatus) {
        byte[] buf = new byte[8];
        int ftStatus = this.cmdGet(32, 0, buf, 8);
        gpioStatus.usb.ep_in = buf[0];
        gpioStatus.usb.ep_out = buf[1];
        gpioStatus.mask = buf[5];
        gpioStatus.dir = buf[6];
        gpioStatus.dat[0] = buf[7];
        if (ftStatus == 8) {
            return 0;
        }
        return ftStatus;
    }

    void getGpioPinLevel(int portNum, byte data, boolean[] value) {
        value[0] = this.IntToBool((data & 1 << portNum) >> portNum & 1);
    }

    boolean is_GPIOPort(int portNum) {
        chiptop_mgr chipStatus = this.mFT4222Device.mChipStatus;
        boolean ret = true;
        switch (chipStatus.chip_mode) {
            case 0: {
                if (!(portNum != 0 && portNum != 1 || chipStatus.function != 1 && chipStatus.function != 2)) {
                    ret = false;
                }
                if (this.IntToBool(chipStatus.enable_suspend_out) && portNum == 2) {
                    ret = false;
                }
                if (!this.IntToBool(chipStatus.enable_wakeup_int) || portNum != 3) break;
                ret = false;
                break;
            }
            case 1: {
                if (portNum == 0 || portNum == 1) {
                    ret = false;
                }
                if (this.IntToBool(chipStatus.enable_suspend_out) && portNum == 2) {
                    ret = false;
                }
                if (!this.IntToBool(chipStatus.enable_wakeup_int) || portNum != 3) break;
                ret = false;
                break;
            }
            case 2: 
            case 3: {
                ret = false;
            }
        }
        return ret;
    }

    boolean is_GPIOPort_Valid_Output(int portNum) {
        gpio_dev gpioStatus = new gpio_dev();
        boolean ret = this.is_GPIOPort(portNum);
        this.getStatus(gpioStatus);
        if (ret && (gpioStatus.dir >> portNum & 1) != 1) {
            ret = false;
        }
        return ret;
    }

    boolean is_GPIOPort_Valid_Input(int portNum) {
        gpio_dev gpioStatus = new gpio_dev();
        boolean ret = this.is_GPIOPort(portNum);
        this.getStatus(gpioStatus);
        if (ret && (gpioStatus.dir >> portNum & 1) != 0) {
            ret = false;
        }
        return ret;
    }

    boolean update_GPIO_Status(int portNum, int gpioStatus) {
        gpio_mgr gpio = new gpio_mgr();
        if (gpio.gpioStatus[portNum] != gpioStatus) {
            int pullup = 0;
            int pulldown = 0;
            int opendrain = 0;
            gpio.gpioStatus[portNum] = gpioStatus;
            int idx = 0;
            while (idx < 4) {
                switch (gpio.gpioStatus[idx]) {
                    case 1: {
                        pullup = (char)(pullup + (1 << idx));
                        break;
                    }
                    case 2: {
                        pulldown = (char)(pulldown + (1 << idx));
                        break;
                    }
                    case 3: {
                        opendrain = (char)(opendrain + (1 << idx));
                    }
                }
                ++idx;
            }
            int ftStatus = this.cmdSet(34, pullup);
            ftStatus |= this.cmdSet(36, pulldown);
            if ((ftStatus |= this.cmdSet(35, opendrain)) == 0) {
                gpio.gpioStatus[portNum] = gpioStatus;
            }
            return ftStatus == 0;
        }
        return true;
    }

    boolean IntToBool(int i) {
        return i != 0;
    }
}

