/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi.j2xx;

import android.content.Context;
import android.content.Intent;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.ftdi.j2xx.D2xxManager;
import com.ftdi.j2xx.FT_Device;
import com.ftdi.j2xx.InBuffer;
import com.ftdi.j2xx.TFtEventNotify;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Pipe;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ProcessInCtrl {
    private static final byte FT_PACKET_SIZE = 64;
    private static final int FT_PACKET_SIZE_HI = 512;
    private static final byte FT_MODEM_STATUS_SIZE = 2;
    private static final int MAX_PACKETS = 256;
    private Semaphore[] mWritable;
    private Semaphore[] mReadable;
    private InBuffer[] mInputBufs;
    private ByteBuffer mMainBuf;
    private ByteBuffer[] mBuffers;
    private Pipe mMainPipe;
    private Pipe.SinkChannel mMainSink;
    private Pipe.SourceChannel mMainSource;
    private int mNrBuf;
    private int mBufInCounter;
    private Object mCounterLock;
    private FT_Device mDevice;
    private D2xxManager.DriverParameters mParams;
    private Lock mInFullLock;
    private Condition mFullCon;
    private boolean mSinkFull;
    private Lock mReadInLock;
    private Condition mReadInCon;
    private Object mSinkFullLock;
    private int mMaxPacketSize;

    public ProcessInCtrl(FT_Device dev) {
        this.mDevice = dev;
        this.mParams = this.mDevice.getDriverParameters();
        this.mNrBuf = this.mParams.getBufferNumber();
        int bufSize = this.mParams.getMaxBufferSize();
        this.mMaxPacketSize = this.mDevice.getMaxPacketSize();
        this.mWritable = new Semaphore[this.mNrBuf];
        this.mReadable = new Semaphore[this.mNrBuf];
        this.mInputBufs = new InBuffer[this.mNrBuf];
        this.mBuffers = new ByteBuffer[256];
        this.mInFullLock = new ReentrantLock();
        this.mFullCon = this.mInFullLock.newCondition();
        this.mSinkFull = false;
        this.mReadInLock = new ReentrantLock();
        this.mReadInCon = this.mReadInLock.newCondition();
        this.mCounterLock = new Object();
        this.mSinkFullLock = new Object();
        this.resetBufCount();
        this.mMainBuf = ByteBuffer.allocateDirect(bufSize);
        try {
            this.mMainPipe = Pipe.open();
            this.mMainSink = this.mMainPipe.sink();
            this.mMainSource = this.mMainPipe.source();
        }
        catch (IOException ex) {
            Log.d((String)"ProcessInCtrl", (String)"Create mMainPipe failed!");
            ex.printStackTrace();
        }
        int i = 0;
        while (i < this.mNrBuf) {
            this.mInputBufs[i] = new InBuffer(bufSize);
            this.mReadable[i] = new Semaphore(1);
            this.mWritable[i] = new Semaphore(1);
            try {
                this.acquireReadableBuffer(i);
            }
            catch (Exception ex) {
                Log.d((String)"ProcessInCtrl", (String)("Acquire read buffer " + i + " failed!"));
                ex.printStackTrace();
            }
            ++i;
        }
    }

    boolean isSinkFull() {
        return this.mSinkFull;
    }

    D2xxManager.DriverParameters getParams() {
        return this.mParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InBuffer getBuffer(int idx) {
        InBuffer buffer = null;
        InBuffer[] inBufferArray = this.mInputBufs;
        synchronized (this.mInputBufs) {
            if (idx >= 0 && idx < this.mNrBuf) {
                buffer = this.mInputBufs[idx];
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return buffer;
        }
    }

    InBuffer acquireWritableBuffer(int idx) throws InterruptedException {
        InBuffer buffer = null;
        this.mWritable[idx].acquire();
        buffer = this.getBuffer(idx);
        if (buffer.acquire(idx) == null) {
            buffer = null;
        }
        return buffer;
    }

    InBuffer acquireReadableBuffer(int idx) throws InterruptedException {
        InBuffer buffer = null;
        this.mReadable[idx].acquire();
        buffer = this.getBuffer(idx);
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWritableBuffer(int idx) throws InterruptedException {
        InBuffer[] inBufferArray = this.mInputBufs;
        synchronized (this.mInputBufs) {
            this.mInputBufs[idx].release(idx);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mWritable[idx].release();
            return;
        }
    }

    public void releaseReadableBuffer(int idx) throws InterruptedException {
        this.mReadable[idx].release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processBulkInData(InBuffer inBuffer) throws D2xxManager.D2xxException {
        int bufSize = 0;
        short signalEvents = 0;
        short signalLineEvents = 0;
        boolean signalRxChar = false;
        try {
            int needS;
            int freeS;
            bufSize = inBuffer.getLength();
            if (bufSize < 2) {
                inBuffer.getInputBuffer().clear();
                return;
            }
            Object object = this.mSinkFullLock;
            synchronized (object) {
                freeS = this.getFreeSpace();
                needS = bufSize - 2;
                if (freeS < needS) {
                    Log.d((String)"ProcessBulkIn::", (String)" Buffer is full, waiting for read....");
                    this.processEventChars(signalRxChar, signalEvents, signalLineEvents);
                    this.mInFullLock.lock();
                    this.mSinkFull = true;
                }
            }
            if (freeS < needS) {
                this.mFullCon.await();
                this.mInFullLock.unlock();
            }
            this.extractReadData(inBuffer);
        }
        catch (InterruptedException ex) {
            this.mInFullLock.unlock();
            Log.e((String)"ProcessInCtrl", (String)"Exception in Full await!");
            ex.printStackTrace();
        }
        catch (Exception ex) {
            Log.e((String)"ProcessInCtrl", (String)"Exception in ProcessBulkIN");
            ex.printStackTrace();
            throw new D2xxManager.D2xxException("Fatal error in BulkIn.");
        }
    }

    private void extractReadData(InBuffer inBuffer) throws InterruptedException {
        int bufSize = 0;
        int nrPackets = 0;
        int totalData = 0;
        int pos = 0;
        int lim = 0;
        long written = 0L;
        short signalEvents = 0;
        short signalLineEvents = 0;
        boolean signalRxChar = false;
        ByteBuffer buffer = null;
        buffer = inBuffer.getInputBuffer();
        bufSize = inBuffer.getLength();
        if (bufSize > 0) {
            nrPackets = bufSize / this.mMaxPacketSize + (bufSize % this.mMaxPacketSize > 0 ? 1 : 0);
            int i = 0;
            while (i < nrPackets) {
                if (i == nrPackets - 1) {
                    lim = bufSize;
                    buffer.limit(lim);
                    pos = i * this.mMaxPacketSize;
                    buffer.position(pos);
                    byte b0 = buffer.get();
                    signalEvents = (short)(this.mDevice.mDeviceInfoNode.modemStatus ^ (short)(b0 & 0xF0));
                    this.mDevice.mDeviceInfoNode.modemStatus = (short)(b0 & 0xF0);
                    byte b1 = buffer.get();
                    this.mDevice.mDeviceInfoNode.lineStatus = (short)(b1 & 0xFF);
                    pos += 2;
                    signalLineEvents = buffer.hasRemaining() ? (short)(this.mDevice.mDeviceInfoNode.lineStatus & 0x1E) : (short)0;
                } else {
                    lim = (i + 1) * this.mMaxPacketSize;
                    buffer.limit(lim);
                    pos = i * this.mMaxPacketSize + 2;
                    buffer.position(pos);
                }
                totalData += lim - pos;
                this.mBuffers[i] = buffer.slice();
                ++i;
            }
            if (totalData != 0) {
                signalRxChar = true;
                try {
                    written = this.mMainSink.write(this.mBuffers, 0, nrPackets);
                    if (written != (long)totalData) {
                        Log.d((String)"extractReadData::", (String)("written != totalData, written= " + written + " totalData=" + totalData));
                    }
                    this.incBufCount((int)written);
                    this.mReadInLock.lock();
                    this.mReadInCon.signalAll();
                    this.mReadInLock.unlock();
                }
                catch (Exception ex) {
                    Log.d((String)"extractReadData::", (String)"Write data to sink failed!!");
                    ex.printStackTrace();
                }
            }
            buffer.clear();
            this.processEventChars(signalRxChar, signalEvents, signalLineEvents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBulkInData(byte[] data, int length, long timeout_ms) {
        boolean i = false;
        int rc = 0;
        int bufSize = this.mParams.getMaxBufferSize();
        long startTime = System.currentTimeMillis();
        ByteBuffer buffer = ByteBuffer.wrap(data, 0, length);
        if (timeout_ms == 0L) {
            timeout_ms = this.mParams.getReadTimeout();
        }
        while (this.mDevice.isOpen()) {
            if (this.getBytesAvailable() >= length) {
                Object object = this.mMainSource;
                synchronized (object) {
                    try {
                        this.mMainSource.read(buffer);
                        this.decBufCount(length);
                    }
                    catch (Exception ex) {
                        Log.d((String)"readBulkInData::", (String)"Cannot read data from Source!!");
                        ex.printStackTrace();
                    }
                }
                object = this.mSinkFullLock;
                synchronized (object) {
                    if (this.mSinkFull) {
                        Log.i((String)"FTDI debug::", (String)"buffer is full , and also re start buffer");
                        this.mInFullLock.lock();
                        this.mFullCon.signalAll();
                        this.mSinkFull = false;
                        this.mInFullLock.unlock();
                    }
                }
                rc = length;
                break;
            }
            try {
                this.mReadInLock.lock();
                this.mReadInCon.await(System.currentTimeMillis() - startTime, TimeUnit.MILLISECONDS);
                this.mReadInLock.unlock();
            }
            catch (InterruptedException ex) {
                Log.d((String)"readBulkInData::", (String)"Cannot wait to read data!!");
                ex.printStackTrace();
                this.mReadInLock.unlock();
            }
            if (System.currentTimeMillis() - startTime >= timeout_ms) break;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int incBufCount(int size) {
        int rc;
        Object object = this.mCounterLock;
        synchronized (object) {
            this.mBufInCounter += size;
            rc = this.mBufInCounter;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int decBufCount(int size) {
        int rc;
        Object object = this.mCounterLock;
        synchronized (object) {
            this.mBufInCounter -= size;
            rc = this.mBufInCounter;
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetBufCount() {
        Object object = this.mCounterLock;
        synchronized (object) {
            this.mBufInCounter = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytesAvailable() {
        int rc;
        Object object = this.mCounterLock;
        synchronized (object) {
            rc = this.mBufInCounter;
        }
        return rc;
    }

    public int getFreeSpace() {
        return this.mParams.getMaxBufferSize() - this.getBytesAvailable() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int purgeINData() {
        int nrBuf = this.mParams.getBufferNumber();
        InBuffer inBuf = null;
        int read = 0;
        ByteBuffer byteBuffer = this.mMainBuf;
        synchronized (byteBuffer) {
            try {
                do {
                    this.mMainSource.configureBlocking(false);
                    read = this.mMainSource.read(this.mMainBuf);
                    this.mMainBuf.clear();
                } while (read != 0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.resetBufCount();
            int i = 0;
            while (i < nrBuf) {
                inBuf = this.getBuffer(i);
                if (inBuf.acquired() && inBuf.getLength() > 2) {
                    inBuf.purge();
                }
                ++i;
            }
        }
        return 0;
    }

    public int processEventChars(boolean fRxChar, short sEvents, short slEvents) throws InterruptedException {
        Intent intent;
        long Mask = 0L;
        short signalEvents = 0;
        short signalLineEvents = 0;
        boolean signalRxChar = fRxChar;
        signalEvents = sEvents;
        signalLineEvents = slEvents;
        Mask = 0L;
        TFtEventNotify Events = new TFtEventNotify();
        Events.Mask = this.mDevice.mEventNotification.Mask;
        if (signalRxChar && (Events.Mask & 1L) != 0L && (this.mDevice.mEventMask ^ 1L) == 1L) {
            this.mDevice.mEventMask |= 1L;
            intent = new Intent("FT_EVENT_RXCHAR");
            intent.putExtra("message", "FT_EVENT_RXCHAR");
            LocalBroadcastManager.getInstance((Context)this.mDevice.mContext).sendBroadcast(intent);
        }
        if (signalEvents != 0 && (Events.Mask & 2L) != 0L && (this.mDevice.mEventMask ^ 2L) == 2L) {
            this.mDevice.mEventMask |= 2L;
            intent = new Intent("FT_EVENT_MODEM_STATUS");
            intent.putExtra("message", "FT_EVENT_MODEM_STATUS");
            LocalBroadcastManager.getInstance((Context)this.mDevice.mContext).sendBroadcast(intent);
        }
        if (signalLineEvents != 0 && (Events.Mask & 4L) != 0L && (this.mDevice.mEventMask ^ 4L) == 4L) {
            this.mDevice.mEventMask |= 4L;
            intent = new Intent("FT_EVENT_LINE_STATUS");
            intent.putExtra("message", "FT_EVENT_LINE_STATUS");
            LocalBroadcastManager.getInstance((Context)this.mDevice.mContext).sendBroadcast(intent);
        }
        return 0;
    }

    public void releaseWritableBuffers() throws InterruptedException {
        int nrBuf = this.mParams.getBufferNumber();
        int i = 0;
        while (i < nrBuf) {
            if (this.getBuffer(i).acquired()) {
                this.releaseWritableBuffer(i);
            }
            ++i;
        }
    }

    void close() {
        int i = 0;
        while (i < this.mNrBuf) {
            try {
                this.releaseReadableBuffer(i);
            }
            catch (Exception ex) {
                Log.d((String)"ProcessInCtrl", (String)("Acquire read buffer " + i + " failed!"));
                ex.printStackTrace();
            }
            this.mInputBufs[i] = null;
            this.mReadable[i] = null;
            this.mWritable[i] = null;
            ++i;
        }
        i = 0;
        while (i < 256) {
            this.mBuffers[i] = null;
            ++i;
        }
        this.mWritable = null;
        this.mReadable = null;
        this.mInputBufs = null;
        this.mBuffers = null;
        this.mMainBuf = null;
        if (this.mSinkFull) {
            this.mInFullLock.lock();
            this.mFullCon.signalAll();
            this.mInFullLock.unlock();
        }
        this.mReadInLock.lock();
        this.mReadInCon.signalAll();
        this.mReadInLock.unlock();
        this.mInFullLock = null;
        this.mFullCon = null;
        this.mCounterLock = null;
        this.mReadInLock = null;
        this.mReadInCon = null;
        try {
            this.mMainSink.close();
            this.mMainSink = null;
            this.mMainSource.close();
            this.mMainSource = null;
            this.mMainPipe = null;
        }
        catch (IOException ex) {
            Log.d((String)"ProcessInCtrl", (String)"Close mMainPipe failed!");
            ex.printStackTrace();
        }
        this.mDevice = null;
        this.mParams = null;
    }
}

