/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils.connection;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.ScanResult;
import android.net.wifi.SupplicantState;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.widget.Toast;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.utils.NetworkUtils;
import timber.log.Timber;

public class WifiConnectionHandler {
    public static final String EXTRA_SSID = "extra_ssid";
    public static final String EXTRA_SSID_PASSWORD = "extra_ssid_password";
    public static final String EXTRA_SCAN_RESULT = "extra_scan_result";
    public static final String SOLO_LINK_WIFI_PREFIX = "SoloLink_";
    private static final IntentFilter intentFilter = new IntentFilter();
    private final BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action;
            switch (action = intent.getAction()) {
                case "android.net.wifi.SCAN_RESULTS": {
                    WifiConnectionHandler.this.notifyWifiScanResultsAvailable(WifiConnectionHandler.this.wifiMgr.getScanResults());
                    break;
                }
                case "android.net.wifi.supplicant.STATE_CHANGE": {
                    SupplicantState supState = (SupplicantState)intent.getParcelableExtra("newState");
                    String ssid = NetworkUtils.getCurrentWifiLink(context);
                    int supplicationError = intent.getIntExtra("supplicantError", -1);
                    Timber.d((String)"Supplicant state changed error %s with state %s and ssid %s", (Object[])new Object[]{supplicationError, supState, ssid});
                    if (supplicationError != 1 || !NetworkUtils.isSoloNetwork(ssid)) break;
                    WifiConnectionHandler.this.notifyWifiConnectionFailed();
                    WifiConfiguration wifiConfig = WifiConnectionHandler.this.getWifiConfigs(ssid);
                    if (wifiConfig == null) break;
                    WifiConnectionHandler.this.wifiMgr.removeNetwork(wifiConfig.networkId);
                    break;
                }
                case "android.net.wifi.STATE_CHANGE": {
                    NetworkInfo netInfo = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    NetworkInfo.State networkState = netInfo == null ? NetworkInfo.State.DISCONNECTED : netInfo.getState();
                    switch (networkState) {
                        case CONNECTED: {
                            WifiInfo wifiInfo = (WifiInfo)intent.getParcelableExtra("wifiInfo");
                            String wifiSSID = wifiInfo.getSSID();
                            Timber.i((String)("Connected to " + wifiSSID), (Object[])new Object[0]);
                            DhcpInfo dhcpInfo = WifiConnectionHandler.this.wifiMgr.getDhcpInfo();
                            if (dhcpInfo != null) {
                                Timber.i((String)"Dhcp info: %s", (Object[])new Object[]{dhcpInfo.toString()});
                            } else {
                                Timber.w((String)"Dhcp info is not available.", (Object[])new Object[0]);
                            }
                            if (wifiSSID == null) break;
                            WifiConnectionHandler.this.updateNetworkIfNecessary(wifiSSID, null);
                            break;
                        }
                        case DISCONNECTED: {
                            Timber.i((String)"Disconnected from wifi network.", (Object[])new Object[0]);
                            WifiConnectionHandler.this.notifyWifiDisconnected();
                            break;
                        }
                        case CONNECTING: {
                            NetworkInfo.DetailedState detailedState;
                            if (Build.VERSION.SDK_INT >= 21 && (detailedState = netInfo.getDetailedState()) != null && detailedState == NetworkInfo.DetailedState.VERIFYING_POOR_LINK) {
                                String connectingSsid = NetworkUtils.getCurrentWifiLink(context);
                                WifiConnectionHandler.this.updateNetworkIfNecessary(connectingSsid, null);
                            }
                            Timber.d((String)"Connecting to wifi network.", (Object[])new Object[0]);
                            WifiConnectionHandler.this.notifyWifiConnecting();
                        }
                    }
                    break;
                }
            }
        }
    };
    private final Object netReq;
    private final Object netReqCb;
    private final AtomicReference<String> connectedWifi = new AtomicReference<String>("");
    private final Context context;
    private final WifiManager wifiMgr;
    private final ConnectivityManager connMgr;
    private WifiConnectionListener listener;

    public WifiConnectionHandler(Context context) {
        this.context = context;
        this.wifiMgr = (WifiManager)this.context.getSystemService("wifi");
        this.connMgr = (ConnectivityManager)this.context.getSystemService("connectivity");
        if (Build.VERSION.SDK_INT >= 21) {
            this.netReq = new NetworkRequest.Builder().addCapability(14).addCapability(12).addCapability(13).addCapability(15).addTransportType(1).build();
            this.netReqCb = new ConnectivityManager.NetworkCallback(){

                @TargetApi(value=21)
                private void getNetworkInfo(Network network) {
                    if (network == null) {
                        Timber.i((String)"Network is null.", (Object[])new Object[0]);
                    } else {
                        Timber.i((String)"Network: %s, active : %s", (Object[])new Object[]{network, WifiConnectionHandler.this.connMgr.isDefaultNetworkActive()});
                        LinkProperties linkProps = WifiConnectionHandler.this.connMgr.getLinkProperties(network);
                        Timber.i((String)"Network link properties: %s", (Object[])new Object[]{linkProps.toString()});
                        Timber.i((String)"Network capabilities: %s", (Object[])new Object[]{WifiConnectionHandler.this.connMgr.getNetworkCapabilities(network)});
                    }
                }

                @TargetApi(value=21)
                public void onAvailable(Network network) {
                    String currentWifi = WifiConnectionHandler.this.getCurrentWifiLink();
                    if (!WifiConnectionHandler.isSoloWifi(currentWifi)) {
                        try {
                            WifiConnectionHandler.this.connMgr.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this);
                        }
                        catch (IllegalArgumentException e) {
                            Timber.w((Throwable)e, (String)"Network callback was not registered.", (Object[])new Object[0]);
                        }
                        return;
                    }
                    Timber.i((String)"Network %s is available", (Object[])new Object[]{network});
                    this.getNetworkInfo(network);
                    Bundle extras = new Bundle(1);
                    extras.putParcelable("extra_network", (Parcelable)network);
                    WifiConnectionHandler.this.notifyWifiConnected(currentWifi, extras);
                }

                public void onLosing(Network network, int maxMsToLive) {
                    Timber.w((String)"Losing network %s", (Object[])new Object[]{network});
                }

                public void onLost(Network network) {
                    Timber.w((String)"Lost network %s", (Object[])new Object[]{network});
                }
            };
        } else {
            this.netReq = null;
            this.netReqCb = null;
        }
    }

    public void setListener(WifiConnectionListener listener) {
        this.listener = listener;
    }

    public void start() {
        this.context.registerReceiver(this.broadcastReceiver, intentFilter);
    }

    public void stop() {
        try {
            this.context.unregisterReceiver(this.broadcastReceiver);
        }
        catch (IllegalArgumentException e) {
            Timber.w((Throwable)e, (String)"Receiver was not registered.", (Object[])new Object[0]);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                this.connMgr.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this.netReqCb);
            }
            catch (IllegalArgumentException e) {
                Timber.w((Throwable)e, (String)"Network callback was not registered.", (Object[])new Object[0]);
            }
        }
    }

    public boolean refreshWifiAPs() {
        Timber.d((String)"Querying wifi access points.", (Object[])new Object[0]);
        if (this.wifiMgr == null) {
            return false;
        }
        if (!this.wifiMgr.isWifiEnabled() && !this.wifiMgr.setWifiEnabled(true)) {
            Toast.makeText((Context)this.context, (CharSequence)"Unable to activate Wi-Fi!", (int)1).show();
            return false;
        }
        return this.wifiMgr.startScan();
    }

    public boolean isOnNetwork(String wifiSsid) {
        if (TextUtils.isEmpty((CharSequence)wifiSsid)) {
            throw new IllegalArgumentException("Invalid wifi ssid " + wifiSsid);
        }
        return wifiSsid.equalsIgnoreCase(this.getCurrentWifiLink());
    }

    public boolean isConnected(String wifiSSID, Bundle info) {
        if (!this.isOnNetwork(wifiSSID)) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Network network;
            Network network2 = network = info == null ? null : (Network)info.getParcelable("extra_network");
            if (network == null) {
                return false;
            }
            NetworkCapabilities netCapabilities = this.connMgr.getNetworkCapabilities(network);
            return netCapabilities != null && netCapabilities.hasTransport(1);
        }
        return true;
    }

    public List<ScanResult> getScanResults() {
        return this.wifiMgr.getScanResults();
    }

    private ScanResult getScanResult(String ssid) {
        if (TextUtils.isEmpty((CharSequence)ssid)) {
            return null;
        }
        List scanResults = this.wifiMgr.getScanResults();
        for (ScanResult result : scanResults) {
            if (!result.SSID.equalsIgnoreCase(ssid)) continue;
            return result;
        }
        return null;
    }

    public int connectToWifi(Bundle info) {
        if (info == null || info.isEmpty()) {
            return -4;
        }
        ScanResult scanResult = (ScanResult)info.getParcelable(EXTRA_SCAN_RESULT);
        if (scanResult == null) {
            String ssid = info.getString(EXTRA_SSID);
            if (TextUtils.isEmpty((CharSequence)ssid)) {
                return -4;
            }
            scanResult = this.getScanResult(ssid);
            if (scanResult == null) {
                Timber.i((String)"No matching scan result was found for id %s", (Object[])new Object[]{ssid});
                return -2;
            }
        }
        Timber.d((String)("Connecting to wifi " + scanResult.SSID), (Object[])new Object[0]);
        if (this.isConnected(scanResult.SSID, info)) {
            Timber.d((String)("Already connected to " + scanResult.SSID), (Object[])new Object[0]);
            this.notifyWifiConnected(scanResult.SSID, info);
            return 0;
        }
        if (this.isOnNetwork(scanResult.SSID)) {
            this.updateNetworkIfNecessary(scanResult.SSID, info);
            return 0;
        }
        WifiConfiguration wifiConfig = this.getWifiConfigs(scanResult.SSID);
        if (wifiConfig == null) {
            String password = info.getString(EXTRA_SSID_PASSWORD);
            Timber.d((String)"Connecting to closed wifi network.", (Object[])new Object[0]);
            if (TextUtils.isEmpty((CharSequence)password)) {
                return -4;
            }
            if (!this.connectToClosedWifi(scanResult, password)) {
                return -7;
            }
            this.wifiMgr.saveConfiguration();
            wifiConfig = this.getWifiConfigs(scanResult.SSID);
        }
        if (wifiConfig != null) {
            this.wifiMgr.enableNetwork(wifiConfig.networkId, true);
            return 0;
        }
        return -7;
    }

    private WifiConfiguration getWifiConfigs(String networkSSID) {
        List networks = this.wifiMgr.getConfiguredNetworks();
        if (networks == null) {
            return null;
        }
        for (WifiConfiguration current : networks) {
            if (current.SSID == null || !current.SSID.equals("\"" + networkSSID + "\"")) continue;
            return current;
        }
        return null;
    }

    private boolean connectToClosedWifi(ScanResult scanResult, String password) {
        WifiConfiguration wifiConf = new WifiConfiguration();
        wifiConf.SSID = "\"" + scanResult.SSID + "\"";
        wifiConf.preSharedKey = "\"" + password + "\"";
        int netId = this.wifiMgr.addNetwork(wifiConf);
        if (netId == -1) {
            Timber.e((String)"Unable to add wifi configuration for %s", (Object[])new Object[]{scanResult.SSID});
            return false;
        }
        return true;
    }

    private static String trimWifiSsid(String wifiSsid) {
        if (TextUtils.isEmpty((CharSequence)wifiSsid)) {
            return "";
        }
        return wifiSsid.replace("\"", "");
    }

    private String getCurrentWifiLink() {
        return WifiConnectionHandler.getCurrentWifiLink(this.wifiMgr);
    }

    public static String getCurrentWifiLink(WifiManager wifiMgr) {
        WifiInfo connectedWifi = wifiMgr.getConnectionInfo();
        String connectedSSID = connectedWifi == null ? null : connectedWifi.getSSID();
        return WifiConnectionHandler.trimWifiSsid(connectedSSID);
    }

    public static boolean isSoloWifi(String wifiSsid) {
        return !TextUtils.isEmpty((CharSequence)wifiSsid) && wifiSsid.startsWith(SOLO_LINK_WIFI_PREFIX);
    }

    private void updateNetworkIfNecessary(String wifiSsid, Bundle info) {
        String trimmedSsid = WifiConnectionHandler.trimWifiSsid(wifiSsid);
        if (this.isConnected(wifiSsid, info)) {
            this.notifyWifiConnected(wifiSsid, info);
            return;
        }
        if (WifiConnectionHandler.isSoloWifi(trimmedSsid)) {
            Timber.i((String)"Requesting route to sololink network", (Object[])new Object[0]);
            if (Build.VERSION.SDK_INT >= 21) {
                this.connMgr.requestNetwork((NetworkRequest)this.netReq, (ConnectivityManager.NetworkCallback)this.netReqCb);
            } else {
                this.notifyWifiConnected(trimmedSsid, info);
            }
        } else {
            this.notifyWifiConnected(trimmedSsid, info);
        }
    }

    private void notifyWifiConnected(String wifiSsid, Bundle extras) {
        if (this.listener != null) {
            this.listener.onWifiConnected(wifiSsid, extras);
        }
    }

    private void notifyWifiConnecting() {
        if (this.listener != null) {
            this.listener.onWifiConnecting();
        }
    }

    private void notifyWifiDisconnected() {
        if (this.listener != null) {
            this.listener.onWifiDisconnected(this.connectedWifi.get());
        }
        this.connectedWifi.set("");
    }

    private void notifyWifiScanResultsAvailable(List<ScanResult> results) {
        if (this.listener != null) {
            this.listener.onWifiScanResultsAvailable(results);
        }
    }

    private void notifyWifiConnectionFailed() {
        if (this.listener != null) {
            LinkConnectionStatus linkConnectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-4, null);
            this.listener.onWifiConnectionFailed(linkConnectionStatus);
        }
    }

    static {
        intentFilter.addAction("android.net.wifi.SCAN_RESULTS");
        intentFilter.addAction("android.net.wifi.STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
        intentFilter.addAction("android.net.wifi.supplicant.STATE_CHANGE");
    }

    public static interface WifiConnectionListener {
        public void onWifiConnected(String var1, Bundle var2);

        public void onWifiConnecting();

        public void onWifiDisconnected(String var1);

        public void onWifiScanResultsAvailable(List<ScanResult> var1);

        public void onWifiConnectionFailed(LinkConnectionStatus var1);
    }
}

