/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils;

import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Pair;
import com.o3dr.services.android.lib.drone.companion.solo.SoloState;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloButtonSettingSetter;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.TLVPacket;
import com.o3dr.services.android.lib.model.ICommandListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.Drone;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.ArduSolo;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo.SoloComp;
import timber.log.Timber;

public class SoloApiUtils {
    private SoloApiUtils() {
    }

    public static SoloState getSoloLinkState(ArduSolo arduSolo) {
        if (arduSolo == null) {
            return null;
        }
        SoloComp soloComp = arduSolo.getSoloComp();
        Pair<String, String> wifiSettings = soloComp.getWifiSettings();
        return new SoloState(soloComp.getAutopilotVersion(), soloComp.getControllerFirmwareVersion(), soloComp.getControllerVersion(), soloComp.getVehicleVersion(), (String)wifiSettings.second, (String)wifiSettings.first, soloComp.getTxPowerCompliantCountry(), soloComp.getButtonSettings(), soloComp.getGimbalVersion(), soloComp.getControllerMode(), soloComp.getControllerUnit());
    }

    public static boolean isSoloLinkFeatureAvailable(Drone drone, ICommandListener listener) {
        if (drone == null) {
            return false;
        }
        if (!(drone instanceof ArduSolo)) {
            if (listener != null) {
                try {
                    listener.onError(3);
                }
                catch (RemoteException e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
            return false;
        }
        return true;
    }

    public static void sendSoloLinkMessage(ArduSolo arduSolo, TLVPacket messageData, ICommandListener listener) {
        if (!SoloApiUtils.isSoloLinkFeatureAvailable(arduSolo, listener) || messageData == null) {
            return;
        }
        SoloComp soloComp = arduSolo.getSoloComp();
        soloComp.sendSoloLinkMessage(messageData, listener);
    }

    public static void updateSoloLinkWifiSettings(ArduSolo arduSolo, String wifiSsid, String wifiPassword, ICommandListener listener) {
        if (!SoloApiUtils.isSoloLinkFeatureAvailable(arduSolo, listener)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)wifiSsid) && TextUtils.isEmpty((CharSequence)wifiPassword)) {
            return;
        }
        SoloComp soloComp = arduSolo.getSoloComp();
        soloComp.updateWifiSettings(wifiSsid, wifiPassword, listener);
    }

    public static void updateSoloLinkButtonSettings(ArduSolo arduSolo, SoloButtonSettingSetter buttonSettings, ICommandListener listener) {
        if (!SoloApiUtils.isSoloLinkFeatureAvailable(arduSolo, listener) || buttonSettings == null) {
            return;
        }
        SoloComp soloComp = arduSolo.getSoloComp();
        soloComp.pushButtonSettings(buttonSettings, listener);
    }

    public static void updateSoloLinkControllerMode(ArduSolo arduSolo, int mode, ICommandListener listener) {
        if (!SoloApiUtils.isSoloLinkFeatureAvailable(arduSolo, listener)) {
            return;
        }
        SoloComp soloComp = arduSolo.getSoloComp();
        soloComp.updateControllerMode(mode, listener);
    }

    public static void updateSoloControllerUnit(ArduSolo arduSolo, String unit, ICommandListener listener) {
        if (!SoloApiUtils.isSoloLinkFeatureAvailable(arduSolo, listener)) {
            return;
        }
        SoloComp soloComp = arduSolo.getSoloComp();
        soloComp.updateControllerUnit(unit, listener);
    }

    public static void updateSoloLinkTxPowerComplianceCountry(ArduSolo arduSolo, String compliantCountry, ICommandListener listener) {
        if (!SoloApiUtils.isSoloLinkFeatureAvailable(arduSolo, listener)) {
            return;
        }
        SoloComp soloComp = arduSolo.getSoloComp();
        soloComp.updateTxPowerComplianceCountry(compliantCountry, listener);
    }
}

