/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.Socket;
import timber.log.Timber;

public class NetworkUtils {
    public static boolean isNetworkAvailable(Context context) {
        if (NetworkUtils.isOnSololinkNetwork(context)) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static String getCurrentWifiLink(Context context) {
        WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
        WifiInfo connectedWifi = wifiMgr.getConnectionInfo();
        String connectedSSID = connectedWifi == null ? null : connectedWifi.getSSID().replace("\"", "");
        return connectedSSID;
    }

    public static boolean isOnSololinkNetwork(Context context) {
        String connectedSSID = NetworkUtils.getCurrentWifiLink(context);
        return NetworkUtils.isSoloNetwork(connectedSSID);
    }

    public static boolean isSoloNetwork(String ssid) {
        return ssid != null && ssid.startsWith("SoloLink_");
    }

    public static void bindSocketToNetwork(Bundle extras, Socket socket) throws IOException {
        if (Build.VERSION.SDK_INT >= 21) {
            Network network = extras == null ? null : (Network)extras.getParcelable("extra_network");
            NetworkUtils.bindSocketToNetwork(network, socket);
        }
    }

    @TargetApi(value=21)
    public static void bindSocketToNetwork(Network network, Socket socket) throws IOException {
        if (Build.VERSION.SDK_INT >= 21 && network != null && socket != null) {
            Timber.d((String)"Binding socket to network %s", (Object[])new Object[]{network});
            network.bindSocket(socket);
        }
    }

    public static void bindSocketToNetwork(Bundle extras, DatagramSocket socket) throws IOException {
        if (Build.VERSION.SDK_INT >= 21) {
            Network network = extras == null ? null : (Network)extras.getParcelable("extra_network");
            NetworkUtils.bindSocketToNetwork(network, socket);
        }
    }

    @TargetApi(value=21)
    public static void bindSocketToNetwork(Network network, DatagramSocket socket) throws IOException {
        if (network != null && socket != null) {
            Timber.d((String)"Binding datagram socket to network %s", (Object[])new Object[]{network});
            if (Build.VERSION.SDK_INT >= 23) {
                network.bindSocket(socket);
            } else if (Build.VERSION.SDK_INT >= 21) {
                try {
                    Method bindSocketMethod = Network.class.getMethod("bindSocket", DatagramSocket.class);
                    bindSocketMethod.invoke((Object)network, socket);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    Timber.e((Throwable)e, (String)"Unable to access Network#bindSocket(DatagramSocket).", (Object[])new Object[0]);
                }
                catch (InvocationTargetException e) {
                    Timber.e((Throwable)e, (String)"Unable to invoke Network#bindSocket(DatagramSocket).", (Object[])new Object[0]);
                }
            }
        }
    }
}

