/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.survey.grid;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.LineLatLong;
import org.droidplanner.services.android.impl.core.helpers.geoTools.LineSampler;
import org.droidplanner.services.android.impl.core.helpers.geoTools.LineTools;

public class EndpointSorter {
    private static final int MAX_NUMBER_OF_CAMERAS = 2000;
    private List<LatLong> gridPoints = new ArrayList<LatLong>();
    private List<LineLatLong> grid;
    private Double sampleDistance;
    private List<LatLong> cameraLocations = new ArrayList<LatLong>();

    public EndpointSorter(List<LineLatLong> grid, Double sampleDistance) {
        this.grid = grid;
        this.sampleDistance = sampleDistance;
    }

    public void sortGrid(LatLong lastpnt, boolean sort) throws Exception {
        while (this.grid.size() > 0) {
            LatLong secondWp;
            LineLatLong closestLine;
            if (sort) {
                closestLine = LineTools.findClosestLineToPoint(lastpnt, this.grid);
                lastpnt = secondWp = this.processOneGridLine(closestLine, lastpnt, sort);
                continue;
            }
            closestLine = this.grid.get(0);
            lastpnt = secondWp = this.processOneGridLine(closestLine, lastpnt, sort);
        }
    }

    private LatLong processOneGridLine(LineLatLong closestLine, LatLong lastpnt, boolean sort) throws Exception {
        LatLong firstWP = closestLine.getClosestEndpointTo(lastpnt);
        LatLong secondWp = closestLine.getFarthestEndpointTo(lastpnt);
        this.grid.remove(closestLine);
        this.updateCameraLocations(firstWP, secondWp);
        this.gridPoints.add(firstWP);
        this.gridPoints.add(secondWp);
        if (this.cameraLocations.size() > 2000) {
            throw new Exception("Too many camera positions");
        }
        return secondWp;
    }

    private void updateCameraLocations(LatLong firstWP, LatLong secondWp) {
        List<LatLong> cameraLocationsOnThisStrip = new LineSampler(firstWP, secondWp).sample(this.sampleDistance);
        this.cameraLocations.addAll(cameraLocationsOnThisStrip);
    }

    public List<LatLong> getSortedGrid() {
        return this.gridPoints;
    }

    public List<LatLong> getCameraLocations() {
        return this.cameraLocations;
    }
}

