/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.survey;

import com.MAVLink.ardupilotmega.msg_camera_feedback;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;
import org.droidplanner.services.android.impl.core.survey.CameraInfo;

public class Footprint {
    private final List<LatLong> vertex = new ArrayList<LatLong>();
    private double meanGSD;

    public Footprint(CameraInfo camera, double altitude) {
        this(camera, new LatLong(0.0, 0.0), (float)altitude, 0.0, 0.0, 0.0);
    }

    public Footprint(CameraInfo camera, msg_camera_feedback msg) {
        this(camera, new LatLong((double)msg.lat / 1.0E7, (double)msg.lng / 1.0E7), msg.alt_rel, msg.pitch, msg.roll, msg.yaw);
    }

    public Footprint(CameraInfo camera, LatLong center, double alt, double pitch, double roll, double yaw) {
        double sx = camera.getSensorLateralSize() / 2.0;
        double sy = camera.getSensorLongitudinalSize() / 2.0;
        double f = camera.focalLength;
        double[][] dcm = MathUtils.dcmFromEuler(Math.toRadians(pitch), Math.toRadians(-roll + 180.0), Math.toRadians(-yaw));
        this.vertex.add(Footprint.cameraFrameToLocalFrame(new LatLong(-sx, -sy), dcm, alt, f, center));
        this.vertex.add(Footprint.cameraFrameToLocalFrame(new LatLong(sx, -sy), dcm, alt, f, center));
        this.vertex.add(Footprint.cameraFrameToLocalFrame(new LatLong(sx, sy), dcm, alt, f, center));
        this.vertex.add(Footprint.cameraFrameToLocalFrame(new LatLong(-sx, sy), dcm, alt, f, center));
        this.meanGSD = 0.001 * this.getLateralSize() * (sy / sx) / Math.sqrt(camera.sensorResolution);
    }

    private static LatLong cameraFrameToLocalFrame(LatLong img, double[][] dcm, double alt, double focalLength, LatLong center) {
        double x = alt * (dcm[0][0] * img.getLatitude() + dcm[1][0] * img.getLongitude() + dcm[2][0] * -focalLength) / (dcm[0][2] * img.getLatitude() + dcm[1][2] * img.getLongitude() + dcm[2][2] * -focalLength);
        double y = alt * (dcm[0][1] * img.getLatitude() + dcm[1][1] * img.getLongitude() + dcm[2][1] * -focalLength) / (dcm[0][2] * img.getLatitude() + dcm[1][2] * img.getLongitude() + dcm[2][2] * -focalLength);
        return GeoTools.moveCoordinate(center, x, y);
    }

    public double getLateralSize() {
        return (GeoTools.getDistance(this.vertex.get(0), this.vertex.get(1)) + GeoTools.getDistance(this.vertex.get(2), this.vertex.get(3))) / 2.0;
    }

    public double getLongitudinalSize() {
        return (GeoTools.getDistance(this.vertex.get(0), this.vertex.get(3)) + GeoTools.getDistance(this.vertex.get(1), this.vertex.get(2))) / 2.0;
    }

    public List<LatLong> getVertexInGlobalFrame() {
        return this.vertex;
    }

    public double getGSD() {
        return this.meanGSD;
    }
}

