/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.mission.waypoints;

import com.MAVLink.common.msg_mission_item;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import java.util.List;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemType;
import org.droidplanner.services.android.impl.core.mission.waypoints.SpatialCoordItem;

public class WaypointImpl
extends SpatialCoordItem {
    private double delay;
    private double acceptanceRadius;
    private double yawAngle;
    private double orbitalRadius;
    private boolean orbitCCW;

    public WaypointImpl(MissionItemImpl item) {
        super(item);
    }

    public WaypointImpl(MissionImpl missionImpl, LatLongAlt coord) {
        super(missionImpl, coord);
    }

    public WaypointImpl(msg_mission_item msg, MissionImpl missionImpl) {
        super(missionImpl, null);
        this.unpackMAVMessage(msg);
    }

    @Override
    public List<msg_mission_item> packMissionItem() {
        List<msg_mission_item> list = super.packMissionItem();
        msg_mission_item mavMsg = list.get(0);
        mavMsg.command = 16;
        mavMsg.param1 = (float)this.getDelay();
        mavMsg.param2 = (float)this.getAcceptanceRadius();
        mavMsg.param3 = (float)(this.isOrbitCCW() ? this.getOrbitalRadius() * -1.0 : this.getOrbitalRadius());
        mavMsg.param4 = (float)this.getYawAngle();
        return list;
    }

    @Override
    public void unpackMAVMessage(msg_mission_item mavMsg) {
        super.unpackMAVMessage(mavMsg);
        this.setDelay(mavMsg.param1);
        this.setAcceptanceRadius(mavMsg.param2);
        this.setOrbitCCW(mavMsg.param3 < 0.0f);
        this.setOrbitalRadius(Math.abs(mavMsg.param3));
        this.setYawAngle(mavMsg.param4);
    }

    @Override
    public MissionItemType getType() {
        return MissionItemType.WAYPOINT;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double delay) {
        this.delay = delay;
    }

    public double getAcceptanceRadius() {
        return this.acceptanceRadius;
    }

    public void setAcceptanceRadius(double acceptanceRadius) {
        this.acceptanceRadius = acceptanceRadius;
    }

    public double getYawAngle() {
        return this.yawAngle;
    }

    public void setYawAngle(double yawAngle) {
        this.yawAngle = yawAngle;
    }

    public double getOrbitalRadius() {
        return this.orbitalRadius;
    }

    public void setOrbitalRadius(double orbitalRadius) {
        this.orbitalRadius = orbitalRadius;
    }

    public boolean isOrbitCCW() {
        return this.orbitCCW;
    }

    public void setOrbitCCW(boolean orbitCCW) {
        this.orbitCCW = orbitCCW;
    }
}

