/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.mission.waypoints;

import com.MAVLink.common.msg_mission_item;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import java.util.List;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;

public abstract class SpatialCoordItem
extends MissionItemImpl {
    protected LatLongAlt coordinate;

    public SpatialCoordItem(MissionImpl missionImpl, LatLongAlt coord) {
        super(missionImpl);
        this.coordinate = coord;
    }

    public SpatialCoordItem(MissionItemImpl item) {
        super(item);
        this.coordinate = item instanceof SpatialCoordItem ? ((SpatialCoordItem)item).getCoordinate() : new LatLongAlt(0.0, 0.0, 0.0);
    }

    public void setCoordinate(LatLongAlt coordNew) {
        this.coordinate = coordNew;
    }

    public LatLongAlt getCoordinate() {
        return this.coordinate;
    }

    @Override
    public List<msg_mission_item> packMissionItem() {
        List<msg_mission_item> list = super.packMissionItem();
        msg_mission_item mavMsg = list.get(0);
        mavMsg.x = (float)this.coordinate.getLatitude();
        mavMsg.y = (float)this.coordinate.getLongitude();
        mavMsg.z = (float)this.coordinate.getAltitude();
        return list;
    }

    @Override
    public void unpackMAVMessage(msg_mission_item mavMsg) {
        this.setCoordinate(new LatLongAlt(mavMsg.x, mavMsg.y, mavMsg.z));
    }

    public void setAltitude(double altitude) {
        this.coordinate.setAltitude(altitude);
    }

    public void setPosition(LatLong position) {
        this.coordinate.set(position);
    }
}

