/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.mission.commands;

import com.MAVLink.common.msg_mission_item;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemType;
import org.droidplanner.services.android.impl.core.mission.commands.MissionCMD;

public class ConditionYawImpl
extends MissionCMD {
    private boolean isRelative = false;
    private double angle = 0.0;
    private double angularSpeed = 0.0;

    public ConditionYawImpl(MissionItemImpl item) {
        super(item);
    }

    public ConditionYawImpl(msg_mission_item msg, MissionImpl missionImpl) {
        super(missionImpl);
        this.unpackMAVMessage(msg);
    }

    public ConditionYawImpl(MissionImpl missionImpl, double angle, boolean isRelative) {
        super(missionImpl);
        this.setAngle(angle);
        this.setRelative(isRelative);
    }

    @Override
    public List<msg_mission_item> packMissionItem() {
        List<msg_mission_item> list = super.packMissionItem();
        msg_mission_item mavMsg = list.get(0);
        mavMsg.command = 115;
        mavMsg.param1 = (float)GeoTools.warpToPositiveAngle(this.angle);
        mavMsg.param2 = (float)Math.abs(this.angularSpeed);
        mavMsg.param3 = this.angularSpeed < 0.0 ? 1.0f : -1.0f;
        mavMsg.param4 = this.isRelative ? 1.0f : 0.0f;
        return list;
    }

    @Override
    public void unpackMAVMessage(msg_mission_item mavMsg) {
        this.isRelative = mavMsg.param4 != 0.0f;
        this.angle = mavMsg.param1;
        this.angularSpeed = mavMsg.param2 * (float)(mavMsg.param3 > 0.0f ? -1 : 1);
    }

    @Override
    public MissionItemType getType() {
        return MissionItemType.CONDITION_YAW;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public void setRelative(boolean isRelative) {
        this.isRelative = isRelative;
    }

    public void setAngularSpeed(double angularSpeed) {
        this.angularSpeed = angularSpeed;
    }

    public double getAngle() {
        return this.angle;
    }

    public double getAngularSpeed() {
        return this.angularSpeed;
    }

    public boolean isRelative() {
        return this.isRelative;
    }
}

