/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.helpers.coordinates;

import com.o3dr.services.android.lib.coordinate.LatLong;
import java.util.List;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public class CoordBounds {
    public LatLong sw_3quadrant;
    public LatLong ne_1quadrant;

    public CoordBounds(LatLong point) {
        this.include(point);
    }

    public CoordBounds(List<LatLong> points) {
        for (LatLong point : points) {
            this.include(point);
        }
    }

    public void include(LatLong point) {
        if (this.sw_3quadrant == null || this.ne_1quadrant == null) {
            this.ne_1quadrant = new LatLong(point);
            this.sw_3quadrant = new LatLong(point);
        } else {
            if (point.getLongitude() > this.ne_1quadrant.getLongitude()) {
                this.ne_1quadrant.setLongitude(point.getLongitude());
            }
            if (point.getLatitude() > this.ne_1quadrant.getLatitude()) {
                this.ne_1quadrant.setLatitude(point.getLatitude());
            }
            if (point.getLongitude() < this.sw_3quadrant.getLongitude()) {
                this.sw_3quadrant.setLongitude(point.getLongitude());
            }
            if (point.getLatitude() < this.sw_3quadrant.getLatitude()) {
                this.sw_3quadrant.setLatitude(point.getLatitude());
            }
        }
    }

    public double getDiag() {
        return GeoTools.latToMeters(GeoTools.getAproximatedDistance(this.ne_1quadrant, this.sw_3quadrant));
    }

    public LatLong getMiddle() {
        return new LatLong((this.ne_1quadrant.getLatitude() + this.sw_3quadrant.getLatitude()) / 2.0, (this.ne_1quadrant.getLongitude() + this.sw_3quadrant.getLongitude()) / 2.0);
    }
}

