/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import android.os.Handler;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import java.util.HashMap;
import java.util.Map;
import org.droidplanner.services.android.impl.core.MAVLink.command.doCmd.MavLinkDoCmds;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAbove;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.roi.ROIEstimator;
import timber.log.Timber;

public class FollowGuidedScan
extends FollowAbove {
    private static final long TIMEOUT = 1000L;
    public static final String EXTRA_FOLLOW_ROI_TARGET = "extra_follow_roi_target";
    public static final double DEFAULT_FOLLOW_ROI_ALTITUDE = 10.0;
    private static final double sDefaultRoiAltitude = 10.0;

    @Override
    public FollowAlgorithm.FollowModes getType() {
        return FollowAlgorithm.FollowModes.GUIDED_SCAN;
    }

    public FollowGuidedScan(MavLinkDroneManager droneMgr, Handler handler) {
        super(droneMgr, handler);
    }

    @Override
    public void updateAlgorithmParams(Map<String, ?> params) {
        super.updateAlgorithmParams(params);
        LatLong tempCoord = (LatLong)params.get(EXTRA_FOLLOW_ROI_TARGET);
        LatLongAlt target = tempCoord == null || tempCoord instanceof LatLongAlt ? (LatLongAlt)tempCoord : new LatLongAlt(tempCoord, 10.0);
        this.getROIEstimator().updateROITarget(target);
    }

    @Override
    protected ROIEstimator initROIEstimator(MavLinkDrone drone, Handler handler) {
        return new GuidedROIEstimator(drone, handler);
    }

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(EXTRA_FOLLOW_ROI_TARGET, this.getROIEstimator().roiTarget);
        return params;
    }

    @Override
    protected GuidedROIEstimator getROIEstimator() {
        return (GuidedROIEstimator)super.getROIEstimator();
    }

    private static class GuidedROIEstimator
    extends ROIEstimator {
        private LatLongAlt roiTarget;

        public GuidedROIEstimator(MavLinkDrone drone, Handler handler) {
            super(drone, handler);
        }

        void updateROITarget(LatLongAlt roiTarget) {
            this.roiTarget = roiTarget;
            this.onLocationUpdate(null);
        }

        @Override
        protected void updateROI() {
            if (this.roiTarget == null) {
                System.out.println("Cancelling ROI lock.");
                super.updateROI();
            } else {
                Timber.d((String)("ROI Target: " + this.roiTarget.toString()), (Object[])new Object[0]);
                MavLinkDoCmds.setROI(this.drone, this.roiTarget, null);
                this.watchdog.postDelayed(this.watchdogCallback, 1000L);
            }
        }
    }
}

