/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import android.os.Handler;
import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.util.MathUtils;
import org.droidplanner.services.android.impl.core.drone.manager.MavLinkDroneManager;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.follow.FollowWithRadiusAlgorithm;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;

public class FollowCircle
extends FollowWithRadiusAlgorithm {
    private double circleStep = 2.0;
    private double circleAngle = 0.0;

    public FollowCircle(MavLinkDroneManager droneMgr, Handler handler, double radius, double rate) {
        super(droneMgr, handler, radius);
        this.circleStep = rate;
    }

    @Override
    public FollowAlgorithm.FollowModes getType() {
        return FollowAlgorithm.FollowModes.CIRCLE;
    }

    @Override
    public void processNewLocation(Location location) {
        LatLong gcsCoord = new LatLong(location.getCoord());
        LatLong goCoord = GeoTools.newCoordFromBearingAndDistance(gcsCoord, this.circleAngle, this.radius);
        this.circleAngle = MathUtils.constrainAngle(this.circleAngle + this.circleStep);
        this.drone.getGuidedPoint().newGuidedCoord(goCoord);
    }
}

