/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs;

import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_heartbeat;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.droidplanner.services.android.impl.communication.model.DataLink;

public class GCSHeartbeat {
    private static final msg_heartbeat sMsg = new msg_heartbeat();
    private final int period;
    private ScheduledExecutorService heartbeatExecutor;
    private final Runnable heartbeatRunnable = new Runnable(){

        @Override
        public void run() {
            GCSHeartbeat.this.dataLink.sendMessage(sMsg, null);
        }
    };
    private final DataLink.DataLinkProvider<MAVLinkMessage> dataLink;

    public GCSHeartbeat(DataLink.DataLinkProvider<MAVLinkMessage> dataLink, int freqHz) {
        this.dataLink = dataLink;
        this.period = freqHz;
    }

    public synchronized void setActive(boolean active) {
        if (active) {
            if (this.heartbeatExecutor == null || this.heartbeatExecutor.isShutdown()) {
                this.heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
                this.heartbeatExecutor.scheduleWithFixedDelay(this.heartbeatRunnable, 0L, this.period, TimeUnit.SECONDS);
            }
        } else if (this.heartbeatExecutor != null && !this.heartbeatExecutor.isShutdown()) {
            this.heartbeatExecutor.shutdownNow();
            this.heartbeatExecutor = null;
        }
    }

    static {
        GCSHeartbeat.sMsg.type = (short)6;
        GCSHeartbeat.sMsg.autopilot = 0;
    }
}

