/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables.calibration;

import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.ardupilotmega.msg_mag_cal_progress;
import com.MAVLink.ardupilotmega.msg_mag_cal_report;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkCalibration;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;

public class MagnetometerCalibrationImpl
extends DroneVariable
implements DroneInterfaces.OnDroneListener<MavLinkDrone> {
    private final HashMap<Short, Info> magCalibrationTracker = new HashMap();
    private OnMagnetometerCalibrationListener listener;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    public MagnetometerCalibrationImpl(MavLinkDrone myDrone) {
        super(myDrone);
        myDrone.addDroneListener(this);
    }

    public void setListener(OnMagnetometerCalibrationListener listener) {
        this.listener = listener;
    }

    public void startCalibration(boolean retryOnFailure, boolean saveAutomatically, int startDelay) {
        this.magCalibrationTracker.clear();
        this.cancelled.set(false);
        MavLinkCalibration.startMagnetometerCalibration(this.myDrone, retryOnFailure, saveAutomatically, startDelay, null);
    }

    public void cancelCalibration() {
        MavLinkCalibration.cancelMagnetometerCalibration(this.myDrone, null);
        this.cancelled.set(true);
        if (this.listener != null) {
            this.listener.onCalibrationCancelled();
        }
    }

    public void acceptCalibration() {
        MavLinkCalibration.acceptMagnetometerCalibration(this.myDrone, null);
    }

    public void processCalibrationMessage(MAVLinkMessage message) {
        switch (message.msgid) {
            case 191: {
                msg_mag_cal_progress progress = (msg_mag_cal_progress)message;
                Info info = this.magCalibrationTracker.get(progress.compass_id);
                if (info == null) {
                    info = new Info();
                    this.magCalibrationTracker.put(progress.compass_id, info);
                }
                info.calProgress = progress;
                if (this.listener == null) break;
                this.listener.onCalibrationProgress(progress);
                break;
            }
            case 192: {
                msg_mag_cal_report report = (msg_mag_cal_report)message;
                Info info = this.magCalibrationTracker.get(report.compass_id);
                if (info == null) {
                    info = new Info();
                    this.magCalibrationTracker.put(report.compass_id, info);
                }
                info.calReport = report;
                if (this.listener == null) break;
                this.listener.onCalibrationCompleted((msg_mag_cal_report)message);
                break;
            }
        }
    }

    public HashMap<Short, Info> getMagCalibrationTracker() {
        return this.magCalibrationTracker;
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case HEARTBEAT_TIMEOUT: 
            case DISCONNECTED: {
                this.cancelCalibration();
            }
        }
    }

    public static class Info {
        msg_mag_cal_progress calProgress;
        msg_mag_cal_report calReport;

        public msg_mag_cal_progress getCalProgress() {
            return this.calProgress;
        }

        public msg_mag_cal_report getCalReport() {
            return this.calReport;
        }
    }

    public static interface OnMagnetometerCalibrationListener {
        public void onCalibrationCancelled();

        public void onCalibrationProgress(msg_mag_cal_progress var1);

        public void onCalibrationCompleted(msg_mag_cal_report var1);
    }
}

