/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables.calibration;

import android.os.Handler;
import android.os.RemoteException;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_statustext;
import com.o3dr.services.android.lib.model.ICommandListener;
import com.o3dr.services.android.lib.model.SimpleCommandListener;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkCalibration;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import timber.log.Timber;

public class AccelCalibration
extends DroneVariable
implements DroneInterfaces.OnDroneListener<MavLinkDrone> {
    private final Runnable onCalibrationStart = new Runnable(){

        @Override
        public void run() {
            ICommandListener listener = AccelCalibration.this.listenerRef.getAndSet(null);
            if (listener != null) {
                try {
                    listener.onSuccess();
                }
                catch (RemoteException e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
        }
    };
    private String mavMsg;
    private boolean calibrating;
    private final Handler handler;
    private final AtomicReference<ICommandListener> listenerRef = new AtomicReference<Object>(null);

    public AccelCalibration(MavLinkDrone drone, Handler handler) {
        super(drone);
        this.handler = handler;
        drone.addDroneListener(this);
    }

    public void startCalibration(ICommandListener listener) {
        if (this.calibrating) {
            if (listener != null) {
                try {
                    listener.onSuccess();
                }
                catch (RemoteException e) {
                    Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                }
            }
            return;
        }
        if (this.myDrone.getState().isFlying()) {
            this.calibrating = false;
        } else {
            this.calibrating = true;
            this.mavMsg = "";
            this.listenerRef.set(listener);
            MavLinkCalibration.startAccelerometerCalibration(this.myDrone, new SimpleCommandListener(){

                @Override
                public void onSuccess() {
                    ICommandListener listener = AccelCalibration.this.listenerRef.getAndSet(null);
                    if (listener != null) {
                        try {
                            listener.onSuccess();
                        }
                        catch (RemoteException e) {
                            Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                }

                @Override
                public void onError(int executionError) {
                    ICommandListener listener = AccelCalibration.this.listenerRef.getAndSet(null);
                    if (listener != null) {
                        try {
                            listener.onError(executionError);
                        }
                        catch (RemoteException e) {
                            Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                }

                @Override
                public void onTimeout() {
                    ICommandListener listener = AccelCalibration.this.listenerRef.getAndSet(null);
                    if (listener != null) {
                        try {
                            listener.onTimeout();
                        }
                        catch (RemoteException e) {
                            Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                        }
                    }
                }
            });
        }
    }

    public void sendAck(int step) {
        if (this.calibrating) {
            MavLinkCalibration.sendCalibrationAckMessage(this.myDrone, step);
        }
    }

    public void processMessage(MAVLinkMessage msg) {
        msg_statustext statusMsg;
        String message;
        if (this.calibrating && msg.msgid == 253 && (message = (statusMsg = (msg_statustext)msg).getText()) != null && (message.startsWith("Place vehicle") || message.startsWith("Calibration"))) {
            this.handler.post(this.onCalibrationStart);
            this.mavMsg = message;
            if (message.startsWith("Calibration")) {
                this.calibrating = false;
            }
            this.myDrone.notifyDroneEvent(DroneInterfaces.DroneEventsType.CALIBRATION_IMU);
        }
    }

    public String getMessage() {
        return this.mavMsg;
    }

    public boolean isCalibrating() {
        return this.calibrating;
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case HEARTBEAT_TIMEOUT: 
            case DISCONNECTED: {
                if (!this.calibrating) break;
                this.cancelCalibration();
            }
        }
    }

    public void cancelCalibration() {
        this.mavMsg = "";
        this.calibrating = false;
    }
}

