/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.variables;

import org.droidplanner.services.android.impl.core.MAVLink.MavLinkStreamRates;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;

public class StreamRates
extends DroneVariable<MavLinkDrone>
implements DroneInterfaces.OnDroneListener<MavLinkDrone> {
    private Rates rates;

    public StreamRates(MavLinkDrone myDrone) {
        super(myDrone);
        myDrone.addDroneListener(this);
    }

    public void setRates(Rates rates) {
        if (this.rates == null || !this.rates.equals(rates)) {
            this.rates = rates;
            if (this.myDrone.isConnected() && this.myDrone.isConnectionAlive()) {
                this.setupStreamRatesFromPref();
            }
        }
    }

    @Override
    public void onDroneEvent(DroneInterfaces.DroneEventsType event, MavLinkDrone drone) {
        switch (event) {
            case CONNECTED: 
            case HEARTBEAT_FIRST: 
            case HEARTBEAT_RESTORED: {
                this.setupStreamRatesFromPref();
                break;
            }
        }
    }

    private void setupStreamRatesFromPref() {
        if (this.rates == null) {
            return;
        }
        MavLinkStreamRates.setupStreamRates(this.myDrone.getMavClient(), this.myDrone.getSysid(), this.myDrone.getCompid(), this.rates.extendedStatus, this.rates.extra1, this.rates.extra2, this.rates.extra3, this.rates.position, this.rates.rcChannels, this.rates.rawSensors, this.rates.rawController);
    }

    public static class Rates {
        public int extendedStatus;
        public int extra1;
        public int extra2;
        public int extra3;
        public int position;
        public int rcChannels;
        public int rawSensors;
        public int rawController;

        public Rates(int rate) {
            this.extendedStatus = rate;
            this.extra1 = rate;
            this.extra2 = rate;
            this.extra3 = rate;
            this.position = rate;
            this.rcChannels = rate;
            this.rawSensors = rate;
            this.rawController = rate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Rates)) {
                return false;
            }
            Rates rates = (Rates)o;
            if (this.extendedStatus != rates.extendedStatus) {
                return false;
            }
            if (this.extra1 != rates.extra1) {
                return false;
            }
            if (this.extra2 != rates.extra2) {
                return false;
            }
            if (this.extra3 != rates.extra3) {
                return false;
            }
            if (this.position != rates.position) {
                return false;
            }
            if (this.rcChannels != rates.rcChannels) {
                return false;
            }
            if (this.rawSensors != rates.rawSensors) {
                return false;
            }
            return this.rawController == rates.rawController;
        }

        public int hashCode() {
            int result = this.extendedStatus;
            result = 31 * result + this.extra1;
            result = 31 * result + this.extra2;
            result = 31 * result + this.extra3;
            result = 31 * result + this.position;
            result = 31 * result + this.rcChannels;
            result = 31 * result + this.rawSensors;
            result = 31 * result + this.rawController;
            return result;
        }
    }
}

