/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm.solo;

import android.content.Context;
import android.os.Handler;
import android.os.RemoteException;
import android.text.TextUtils;
import com.o3dr.android.client.utils.connection.AbstractIpConnection;
import com.o3dr.android.client.utils.connection.IpConnectionListener;
import com.o3dr.services.android.lib.model.ICommandListener;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.utils.connection.SshConnection;
import timber.log.Timber;

public abstract class AbstractLinkManager<T extends LinkListener>
implements IpConnectionListener {
    protected static final String SOLO_MAC_ADDRESS_COMMAND = "/sbin/ifconfig wlan0 | awk '/HWaddr/ {print $NF}'";
    protected static final long RECONNECT_COUNTDOWN = 1000L;
    private final Runnable reconnectTask = new Runnable(){

        @Override
        public void run() {
            AbstractLinkManager.this.handler.removeCallbacks(AbstractLinkManager.this.reconnectTask);
            AbstractLinkManager.this.linkConn.connect(AbstractLinkManager.this.linkProvider.getConnectionExtras());
        }
    };
    private final Runnable macAddressRetriever = new Runnable(){

        @Override
        public void run() {
            try {
                String response = AbstractLinkManager.this.getSshLink().execute(AbstractLinkManager.SOLO_MAC_ADDRESS_COMMAND);
                String trimmedResponse = TextUtils.isEmpty((CharSequence)response) ? "" : response.trim();
                AbstractLinkManager.this.setMacAddress(trimmedResponse);
            }
            catch (IOException e) {
                Timber.e((Throwable)e, (String)"Error occurred while retrieving sololink mac address", (Object[])new Object[0]);
            }
        }
    };
    private final AtomicReference<String> macAddress = new AtomicReference<String>("");
    private final ExecutorService asyncExecutor;
    protected final Handler handler;
    private final AtomicBoolean isStarted = new AtomicBoolean(false);
    private final AtomicBoolean wasConnected = new AtomicBoolean(false);
    protected final Context context;
    protected final AbstractIpConnection linkConn;
    protected final DataLink.DataLinkProvider linkProvider;
    private T linkListener;

    public abstract void refreshState();

    public AbstractLinkManager(Context context, AbstractIpConnection ipConn, Handler handler, ExecutorService asyncExecutor, DataLink.DataLinkProvider linkProvider) {
        this.context = context;
        this.linkConn = ipConn;
        this.linkConn.setIpConnectionListener(this);
        this.handler = handler;
        this.asyncExecutor = asyncExecutor;
        this.linkProvider = linkProvider;
    }

    protected void postAsyncTask(Runnable task) {
        if (this.asyncExecutor != null && !this.asyncExecutor.isShutdown()) {
            this.asyncExecutor.execute(task);
        }
    }

    protected void postSuccessEvent(final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onSuccess();
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    protected void postTimeoutEvent(final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onTimeout();
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    protected void postErrorEvent(final int error, final ICommandListener listener) {
        if (this.handler != null && listener != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        listener.onError(error);
                    }
                    catch (RemoteException e) {
                        Timber.e((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
                    }
                }
            });
        }
    }

    protected abstract SshConnection getSshLink();

    public boolean isLinkConnected() {
        return this.linkConn.getConnectionStatus() == 2;
    }

    public void start(T listener) {
        this.handler.removeCallbacks(this.reconnectTask);
        this.isStarted.set(true);
        this.linkConn.connect(this.linkProvider.getConnectionExtras());
        this.linkListener = listener;
    }

    public void stop() {
        this.handler.removeCallbacks(this.reconnectTask);
        this.isStarted.set(false);
        this.linkConn.disconnect();
    }

    @Override
    public void onIpConnected() {
        this.handler.removeCallbacks(this.reconnectTask);
        this.wasConnected.set(true);
        this.refreshState();
        if (this.linkListener != null) {
            this.linkListener.onLinkConnected();
        }
    }

    protected boolean isStarted() {
        return this.isStarted.get();
    }

    @Override
    public void onIpDisconnected() {
        if (this.isStarted.get() && this.shouldReconnect()) {
            this.handler.postDelayed(this.reconnectTask, 1000L);
        }
        if (this.linkListener != null && this.wasConnected.compareAndSet(true, false)) {
            this.linkListener.onLinkDisconnected();
        }
    }

    protected boolean shouldReconnect() {
        return true;
    }

    protected void loadMacAddress() {
        this.postAsyncTask(this.macAddressRetriever);
    }

    private void setMacAddress(String trimmedResponse) {
        Timber.i((String)"Retrieved mac address: %s", (Object[])new Object[]{trimmedResponse});
        this.macAddress.set(trimmedResponse);
        if (this.linkListener != null) {
            this.linkListener.onMacAddressUpdated();
        }
    }

    public String getMacAddress() {
        return this.macAddress.get();
    }

    public static interface LinkListener {
        public void onLinkConnected();

        public void onLinkDisconnected();

        public void onVersionsUpdated();

        public void onMacAddressUpdated();
    }
}

