/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.drone.autopilot.apm;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.MAVLink.Messages.MAVLinkMessage;
import com.github.zafarkhaja.semver.Version;
import com.o3dr.services.android.lib.drone.property.Parameter;
import com.o3dr.services.android.lib.model.ICommandListener;
import java.util.concurrent.ConcurrentHashMap;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkCommands;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.LogMessageListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.apm.ArduPilot;
import org.droidplanner.services.android.impl.core.drone.profiles.ParameterManager;
import org.droidplanner.services.android.impl.core.drone.variables.ApmModes;
import org.droidplanner.services.android.impl.core.drone.variables.State;
import org.droidplanner.services.android.impl.core.firmware.FirmwareType;
import org.droidplanner.services.android.impl.core.model.AutopilotWarningParser;
import org.droidplanner.services.android.impl.utils.CommonApiUtils;

public class ArduCopter
extends ArduPilot {
    private static final Version ARDU_COPTER_V3_3 = Version.forIntegers((int)3, (int)3, (int)0);
    private static final Version ARDU_COPTER_V3_4 = Version.forIntegers((int)3, (int)4, (int)0);
    private static final Version BRAKE_FEATURE_FIRMWARE_VERSION = ARDU_COPTER_V3_3;
    private static final Version COMPASS_CALIBRATION_MIN_VERSION = ARDU_COPTER_V3_4;
    private final ConcurrentHashMap<String, ICommandListener> manualControlStateListeners = new ConcurrentHashMap();

    public ArduCopter(String droneId, Context context, DataLink.DataLinkProvider<MAVLinkMessage> mavClient, Handler handler, AutopilotWarningParser warningParser, LogMessageListener logListener) {
        super(droneId, context, mavClient, handler, warningParser, logListener);
    }

    @Override
    public FirmwareType getFirmwareType() {
        return FirmwareType.ARDU_COPTER;
    }

    @Override
    protected boolean setVelocity(Bundle data, ICommandListener listener) {
        float normalizedXVel = data.getFloat("extra_velocity_x");
        float normalizedYVel = data.getFloat("extra_velocity_y");
        float normalizedZVel = data.getFloat("extra_velocity_z");
        double attitudeInRad = Math.toRadians(this.attitude.getYaw());
        double cosAttitude = Math.cos(attitudeInRad);
        double sinAttitude = Math.sin(attitudeInRad);
        float projectedX = (float)((double)normalizedXVel * cosAttitude) - (float)((double)normalizedYVel * sinAttitude);
        float projectedY = (float)((double)normalizedXVel * sinAttitude) + (float)((double)normalizedYVel * cosAttitude);
        float defaultSpeed = 5.0f;
        ParameterManager parameterManager = this.getParameterManager();
        Parameter horizSpeedParam = parameterManager.getParameter("WPNAV_SPEED");
        double horizontalSpeed = horizSpeedParam == null ? (double)defaultSpeed : horizSpeedParam.getValue() / 100.0;
        String vertSpeedParamName = normalizedZVel >= 0.0f ? "WPNAV_SPEED_UP" : "WPNAV_SPEED_DN";
        Parameter vertSpeedParam = parameterManager.getParameter(vertSpeedParamName);
        double verticalSpeed = vertSpeedParam == null ? (double)defaultSpeed : vertSpeedParam.getValue() / 100.0;
        MavLinkCommands.setVelocityInLocalFrame(this, (float)((double)projectedX * horizontalSpeed), (float)((double)projectedY * horizontalSpeed), (float)((double)normalizedZVel * verticalSpeed), listener);
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.manualControlStateListeners.clear();
    }

    @Override
    protected boolean enableManualControl(Bundle data, ICommandListener listener) {
        boolean enable = data.getBoolean("extra_do_enable");
        String appId = data.getString("extra_client_app_id");
        State state = this.getState();
        ApmModes vehicleMode = state.getMode();
        if (enable) {
            if (vehicleMode == ApmModes.ROTOR_GUIDED) {
                CommonApiUtils.postSuccessEvent(listener);
            } else {
                state.changeFlightMode(ApmModes.ROTOR_GUIDED, listener);
            }
            if (listener != null) {
                this.manualControlStateListeners.put(appId, listener);
            }
        } else {
            this.manualControlStateListeners.remove(appId);
            if (vehicleMode != ApmModes.ROTOR_GUIDED) {
                CommonApiUtils.postSuccessEvent(listener);
            } else {
                state.changeFlightMode(ApmModes.ROTOR_LOITER, listener);
            }
        }
        return true;
    }

    @Override
    public void notifyDroneEvent(DroneInterfaces.DroneEventsType event) {
        switch (event) {
            case MODE: {
                ApmModes currentMode = this.getState().getMode();
                for (ICommandListener listener : this.manualControlStateListeners.values()) {
                    if (currentMode == ApmModes.ROTOR_GUIDED) {
                        CommonApiUtils.postSuccessEvent(listener);
                        continue;
                    }
                    CommonApiUtils.postErrorEvent(4, listener);
                }
                break;
            }
        }
        super.notifyDroneEvent(event);
    }

    @Override
    protected boolean isFeatureSupported(String featureId) {
        switch (featureId) {
            case "feature_kill_switch": {
                return CommonApiUtils.isKillSwitchSupported(this);
            }
            case "feature_compass_calibration": {
                return this.getFirmwareVersionNumber().greaterThanOrEqualTo(COMPASS_CALIBRATION_MIN_VERSION);
            }
        }
        return super.isFeatureSupported(featureId);
    }

    @Override
    protected boolean brakeVehicle(ICommandListener listener) {
        if (this.getFirmwareVersionNumber().greaterThanOrEqualTo(BRAKE_FEATURE_FIRMWARE_VERSION)) {
            this.getState().changeFlightMode(ApmModes.ROTOR_BRAKE, listener);
        } else {
            super.brakeVehicle(listener);
        }
        return true;
    }
}

