/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.MAVLink.connection;

import android.content.Context;
import android.os.Bundle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.droidplanner.services.android.impl.core.MAVLink.connection.MavLinkConnection;
import org.droidplanner.services.android.impl.utils.NetworkUtils;

public abstract class TcpConnection
extends MavLinkConnection {
    private static final int CONNECTION_TIMEOUT = 20000;
    private Socket socket;
    private BufferedOutputStream mavOut;
    private BufferedInputStream mavIn;
    private String serverIP;
    private int serverPort;

    protected TcpConnection(Context context) {
        super(context);
    }

    @Override
    public final void openConnection(Bundle connectionExtras) throws IOException {
        this.getTCPStream(connectionExtras);
        this.onConnectionOpened(connectionExtras);
    }

    @Override
    public final int readDataBlock(byte[] buffer) throws IOException {
        return this.mavIn.read(buffer);
    }

    @Override
    public final void sendBuffer(byte[] buffer) throws IOException {
        if (this.mavOut != null) {
            this.mavOut.write(buffer);
            this.mavOut.flush();
        }
    }

    @Override
    public final void loadPreferences() {
        this.serverIP = this.loadServerIP();
        this.serverPort = this.loadServerPort();
    }

    protected abstract int loadServerPort();

    protected abstract String loadServerIP();

    @Override
    public final void closeConnection() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    private void getTCPStream(Bundle extras) throws IOException {
        InetAddress serverAddr = InetAddress.getByName(this.serverIP);
        this.socket = new Socket();
        NetworkUtils.bindSocketToNetwork(extras, this.socket);
        this.socket.connect(new InetSocketAddress(serverAddr, this.serverPort), 20000);
        this.mavOut = new BufferedOutputStream(this.socket.getOutputStream());
        this.mavIn = new BufferedInputStream(this.socket.getInputStream());
    }

    @Override
    public final int getConnectionType() {
        return 2;
    }
}

