/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.MAVLink.command.doCmd;

import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.ardupilotmega.msg_digicam_control;
import com.MAVLink.ardupilotmega.msg_mount_control;
import com.MAVLink.common.msg_command_long;
import com.MAVLink.common.msg_mission_set_current;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import com.o3dr.services.android.lib.model.ICommandListener;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;

public class MavLinkDoCmds {
    public static void setVehicleHome(MavLinkDrone drone, LatLongAlt location, ICommandListener listener) {
        if (drone == null || location == null) {
            return;
        }
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 179;
        msg.param5 = (float)location.getLatitude();
        msg.param6 = (float)location.getLongitude();
        msg.param7 = (float)location.getAltitude();
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void setROI(MavLinkDrone drone, LatLongAlt coord, ICommandListener listener) {
        if (drone == null) {
            return;
        }
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 201;
        msg.param5 = (float)coord.getLatitude();
        msg.param6 = (float)coord.getLongitude();
        msg.param7 = (float)coord.getAltitude();
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void resetROI(MavLinkDrone drone, ICommandListener listener) {
        if (drone == null) {
            return;
        }
        MavLinkDoCmds.setROI(drone, new LatLongAlt(0.0, 0.0, 0.0), listener);
    }

    public static void triggerCamera(MavLinkDrone drone) {
        if (drone == null) {
            return;
        }
        msg_digicam_control msg = new msg_digicam_control();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.shot = 1;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, null);
    }

    public static void empCommand(MavLinkDrone drone, boolean release, ICommandListener listener) {
        if (drone == null) {
            return;
        }
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 211;
        msg.param2 = release ? 0.0f : 1.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void setRelay(MavLinkDrone drone, int relayNumber, boolean enabled, ICommandListener listener) {
        if (drone == null) {
            return;
        }
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 181;
        msg.param1 = relayNumber;
        msg.param2 = enabled ? 1.0f : 0.0f;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void setServo(MavLinkDrone drone, int channel, int pwm, ICommandListener listener) {
        if (drone == null) {
            return;
        }
        msg_command_long msg = new msg_command_long();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.command = 183;
        msg.param1 = channel;
        msg.param2 = pwm;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void setGimbalOrientation(MavLinkDrone drone, float pitch, float roll, float yaw, ICommandListener listener) {
        if (drone == null) {
            return;
        }
        msg_mount_control msg = new msg_mount_control();
        msg.target_system = drone.getSysid();
        msg.target_component = drone.getCompid();
        msg.input_a = (int)(pitch * 100.0f);
        msg.input_b = (int)(roll * 100.0f);
        msg.input_c = (int)(yaw * 100.0f);
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }

    public static void gotoWaypoint(MavLinkDrone drone, int waypoint, ICommandListener listener) {
        if (drone == null) {
            return;
        }
        msg_mission_set_current msg = new msg_mission_set_current();
        msg.seq = waypoint;
        drone.getMavClient().sendMessage((MAVLinkMessage)msg, listener);
    }
}

