/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.MAVLink;

import android.os.Handler;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.common.msg_mission_ack;
import com.MAVLink.common.msg_mission_count;
import com.MAVLink.common.msg_mission_current;
import com.MAVLink.common.msg_mission_item;
import com.MAVLink.common.msg_mission_item_reached;
import com.MAVLink.common.msg_mission_request;
import java.util.ArrayList;
import java.util.List;
import org.droidplanner.services.android.impl.core.MAVLink.MavLinkWaypoint;
import org.droidplanner.services.android.impl.core.drone.DroneInterfaces;
import org.droidplanner.services.android.impl.core.drone.DroneVariable;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;

public class WaypointManager
extends DroneVariable {
    private static final long TIMEOUT = 15000L;
    private static final int RETRY_LIMIT = 3;
    private int retryTracker = 0;
    private int readIndex;
    private int writeIndex;
    private int retryIndex;
    private DroneInterfaces.OnWaypointManagerListener wpEventListener;
    WaypointStates state = WaypointStates.IDLE;
    private final Handler watchdog;
    private final Runnable watchdogCallback = new Runnable(){

        @Override
        public void run() {
            if (WaypointManager.this.processTimeOut(++WaypointManager.this.retryTracker)) {
                WaypointManager.this.watchdog.postDelayed((Runnable)this, 15000L);
            }
        }
    };
    private int waypointCount;
    private List<msg_mission_item> mission = new ArrayList<msg_mission_item>();

    public WaypointManager(MavLinkDrone drone, Handler handler) {
        super(drone);
        this.watchdog = handler;
    }

    public void setWaypointManagerListener(DroneInterfaces.OnWaypointManagerListener wpEventListener) {
        this.wpEventListener = wpEventListener;
    }

    private void startWatchdog() {
        this.stopWatchdog();
        this.retryTracker = 0;
        this.watchdog.postDelayed(this.watchdogCallback, 15000L);
    }

    private void stopWatchdog() {
        this.watchdog.removeCallbacks(this.watchdogCallback);
    }

    public void getWaypoints() {
        if (this.state != WaypointStates.IDLE) {
            return;
        }
        this.doBeginWaypointEvent(WaypointEvent_Type.WP_DOWNLOAD);
        this.readIndex = -1;
        this.state = WaypointStates.READ_REQUEST;
        MavLinkWaypoint.requestWaypointsList(this.myDrone);
        this.startWatchdog();
    }

    public void writeWaypoints(List<msg_mission_item> data) {
        if (this.state != WaypointStates.IDLE) {
            return;
        }
        if (this.mission != null) {
            this.doBeginWaypointEvent(WaypointEvent_Type.WP_UPLOAD);
            this.mission.clear();
            this.mission.addAll(data);
            this.writeIndex = 0;
            this.state = WaypointStates.WRITING_WP_COUNT;
            MavLinkWaypoint.sendWaypointCount(this.myDrone, this.mission.size());
            this.startWatchdog();
        }
    }

    public void setCurrentWaypoint(int i) {
        if (this.mission != null) {
            MavLinkWaypoint.sendSetCurrentWaypoint(this.myDrone, (short)i);
        }
    }

    public void onWaypointReached(int wpNumber) {
    }

    private void onCurrentWaypointUpdate(int seq) {
    }

    public boolean processMessage(MAVLinkMessage msg) {
        switch (this.state) {
            default: {
                break;
            }
            case READ_REQUEST: {
                if (msg.msgid != 44) break;
                this.waypointCount = ((msg_mission_count)msg).count;
                this.mission.clear();
                this.startWatchdog();
                MavLinkWaypoint.requestWayPoint(this.myDrone, this.mission.size());
                this.state = WaypointStates.READING_WP;
                return true;
            }
            case READING_WP: {
                if (msg.msgid != 39) break;
                this.startWatchdog();
                this.processReceivedWaypoint((msg_mission_item)msg);
                this.doWaypointEvent(WaypointEvent_Type.WP_DOWNLOAD, this.readIndex + 1, this.waypointCount);
                if (this.mission.size() < this.waypointCount) {
                    MavLinkWaypoint.requestWayPoint(this.myDrone, this.mission.size());
                } else {
                    this.stopWatchdog();
                    this.state = WaypointStates.IDLE;
                    MavLinkWaypoint.sendAck(this.myDrone);
                    this.myDrone.getMission().onMissionReceived(this.mission);
                    this.doEndWaypointEvent(WaypointEvent_Type.WP_DOWNLOAD);
                }
                return true;
            }
            case WRITING_WP_COUNT: {
                this.state = WaypointStates.WRITING_WP;
            }
            case WRITING_WP: {
                if (msg.msgid != 40) break;
                this.startWatchdog();
                this.processWaypointToSend((msg_mission_request)msg);
                this.doWaypointEvent(WaypointEvent_Type.WP_UPLOAD, this.writeIndex + 1, this.mission.size());
                return true;
            }
            case WAITING_WRITE_ACK: {
                if (msg.msgid != 47) break;
                this.stopWatchdog();
                this.myDrone.getMission().onWriteWaypoints((msg_mission_ack)msg);
                this.state = WaypointStates.IDLE;
                this.doEndWaypointEvent(WaypointEvent_Type.WP_UPLOAD);
                return true;
            }
        }
        if (msg.msgid == 46) {
            this.onWaypointReached(((msg_mission_item_reached)msg).seq);
            return true;
        }
        if (msg.msgid == 42) {
            this.onCurrentWaypointUpdate(((msg_mission_current)msg).seq);
            return true;
        }
        return false;
    }

    public boolean processTimeOut(int mTimeOutCount) {
        if (mTimeOutCount >= 3) {
            this.state = WaypointStates.IDLE;
            this.doWaypointEvent(WaypointEvent_Type.WP_TIMED_OUT, this.retryIndex, 3);
            return false;
        }
        ++this.retryIndex;
        this.doWaypointEvent(WaypointEvent_Type.WP_RETRY, this.retryIndex, 3);
        switch (this.state) {
            default: {
                break;
            }
            case READ_REQUEST: {
                MavLinkWaypoint.requestWaypointsList(this.myDrone);
                break;
            }
            case READING_WP: {
                if (this.mission.size() >= this.waypointCount) break;
                MavLinkWaypoint.requestWayPoint(this.myDrone, this.mission.size());
                break;
            }
            case WRITING_WP_COUNT: {
                MavLinkWaypoint.sendWaypointCount(this.myDrone, this.mission.size());
                break;
            }
            case WRITING_WP: {
                if (this.writeIndex >= this.mission.size()) break;
                this.myDrone.getMavClient().sendMessage((MAVLinkMessage)this.mission.get(this.writeIndex), null);
                break;
            }
            case WAITING_WRITE_ACK: {
                this.myDrone.getMavClient().sendMessage((MAVLinkMessage)this.mission.get(this.mission.size() - 1), null);
            }
        }
        return true;
    }

    private void processWaypointToSend(msg_mission_request msg) {
        this.writeIndex = msg.seq;
        msg_mission_item item = this.mission.get(this.writeIndex);
        item.target_system = this.myDrone.getSysid();
        item.target_component = this.myDrone.getCompid();
        this.myDrone.getMavClient().sendMessage((MAVLinkMessage)item, null);
        if (this.writeIndex + 1 >= this.mission.size()) {
            this.state = WaypointStates.WAITING_WRITE_ACK;
        }
    }

    private void processReceivedWaypoint(msg_mission_item msg) {
        if (msg.seq <= this.readIndex) {
            return;
        }
        this.readIndex = msg.seq;
        this.mission.add(msg);
    }

    private void doBeginWaypointEvent(WaypointEvent_Type wpEvent) {
        this.retryIndex = 0;
        if (this.wpEventListener == null) {
            return;
        }
        this.wpEventListener.onBeginWaypointEvent(wpEvent);
    }

    private void doEndWaypointEvent(WaypointEvent_Type wpEvent) {
        if (this.retryIndex > 0) {
            this.doWaypointEvent(WaypointEvent_Type.WP_CONTINUE, this.retryIndex, 3);
        }
        this.retryIndex = 0;
        if (this.wpEventListener == null) {
            return;
        }
        this.wpEventListener.onEndWaypointEvent(wpEvent);
    }

    private void doWaypointEvent(WaypointEvent_Type wpEvent, int index, int count) {
        this.retryIndex = 0;
        if (this.wpEventListener == null) {
            return;
        }
        this.wpEventListener.onWaypointEvent(wpEvent, index, count);
    }

    public static enum WaypointEvent_Type {
        WP_UPLOAD,
        WP_DOWNLOAD,
        WP_RETRY,
        WP_CONTINUE,
        WP_TIMED_OUT;

    }

    static enum WaypointStates {
        IDLE,
        READ_REQUEST,
        READING_WP,
        WRITING_WP_COUNT,
        WRITING_WP,
        WAITING_WRITE_ACK;

    }
}

