/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.communication.service;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.MAVLink.MAVLinkPacket;
import com.MAVLink.Messages.MAVLinkMessage;
import com.o3dr.services.android.lib.drone.connection.ConnectionParameter;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import com.o3dr.services.android.lib.model.ICommandListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.droidplanner.services.android.impl.communication.connection.AndroidMavLinkConnection;
import org.droidplanner.services.android.impl.communication.connection.AndroidTcpConnection;
import org.droidplanner.services.android.impl.communication.connection.AndroidUdpConnection;
import org.droidplanner.services.android.impl.communication.connection.BluetoothConnection;
import org.droidplanner.services.android.impl.communication.connection.SoloConnection;
import org.droidplanner.services.android.impl.communication.connection.usb.UsbConnection;
import org.droidplanner.services.android.impl.communication.model.DataLink;
import org.droidplanner.services.android.impl.core.MAVLink.connection.MavLinkConnectionListener;
import org.droidplanner.services.android.impl.core.drone.manager.DroneCommandTracker;
import org.droidplanner.services.android.impl.utils.connection.WifiConnectionHandler;
import timber.log.Timber;

public class MAVLinkClient
implements DataLink.DataLinkProvider<MAVLinkMessage> {
    private static final int DEFAULT_SYS_ID = 255;
    private static final int DEFAULT_COMP_ID = 190;
    private static final int MAX_PACKET_SEQUENCE = 255;
    private final MavLinkConnectionListener mConnectionListener = new MavLinkConnectionListener(){

        @Override
        public void onReceivePacket(MAVLinkPacket packet) {
            MAVLinkClient.this.listener.notifyReceivedData(packet);
        }

        @Override
        public void onConnectionStatus(LinkConnectionStatus connectionStatus) {
            MAVLinkClient.this.listener.onConnectionStatus(connectionStatus);
            switch (connectionStatus.getStatusCode()) {
                case "DISCONNECTED": {
                    MAVLinkClient.this.closeConnection();
                }
            }
        }
    };
    private AndroidMavLinkConnection mavlinkConn;
    private final DataLink.DataLinkListener<MAVLinkPacket> listener;
    private final Context context;
    private int packetSeqNumber = 0;
    private final ConnectionParameter connParams;
    private DroneCommandTracker commandTracker;

    public MAVLinkClient(Context context, DataLink.DataLinkListener<MAVLinkPacket> listener, ConnectionParameter connParams, DroneCommandTracker commandTracker) {
        this.context = context;
        this.listener = listener;
        if (connParams == null) {
            throw new NullPointerException("Invalid connection parameter argument.");
        }
        this.connParams = connParams;
        this.commandTracker = commandTracker;
    }

    private int getConnectionStatus() {
        return this.mavlinkConn == null ? 0 : this.mavlinkConn.getConnectionStatus();
    }

    @Override
    public synchronized void openConnection() {
        String pingIpAddress;
        if (this.isConnected() || this.isConnecting()) {
            return;
        }
        String tag = this.toString();
        int connectionType = this.connParams.getConnectionType();
        Bundle paramsBundle = this.connParams.getParamsBundle();
        if (this.mavlinkConn == null) {
            switch (connectionType) {
                case 0: {
                    int baudRate = paramsBundle.getInt("extra_usb_baud_rate", 57600);
                    this.mavlinkConn = new UsbConnection(this.context, baudRate);
                    Timber.i((String)"Connecting over usb.", (Object[])new Object[0]);
                    break;
                }
                case 3: {
                    String bluetoothAddress = paramsBundle.getString("extra_bluetooth_address");
                    this.mavlinkConn = new BluetoothConnection(this.context, bluetoothAddress);
                    Timber.i((String)"Connecting over bluetooth.", (Object[])new Object[0]);
                    break;
                }
                case 2: {
                    String tcpServerIp = paramsBundle.getString("extra_tcp_server_ip");
                    int tcpServerPort = paramsBundle.getInt("extra_tcp_server_port", 5763);
                    this.mavlinkConn = new AndroidTcpConnection(this.context, tcpServerIp, tcpServerPort, new WifiConnectionHandler(this.context));
                    Timber.i((String)"Connecting over tcp.", (Object[])new Object[0]);
                    break;
                }
                case 1: {
                    int udpServerPort = paramsBundle.getInt("extra_udp_server_port", 14550);
                    this.mavlinkConn = new AndroidUdpConnection(this.context, udpServerPort, new WifiConnectionHandler(this.context));
                    Timber.i((String)"Connecting over udp.", (Object[])new Object[0]);
                    break;
                }
                case 101: {
                    Timber.i((String)"Creating solo connection", (Object[])new Object[0]);
                    String soloLinkId = paramsBundle.getString("extra_solo_link_id", null);
                    String linkPassword = paramsBundle.getString("extra_solo_link_password", null);
                    this.mavlinkConn = new SoloConnection(this.context, soloLinkId, linkPassword);
                    break;
                }
                default: {
                    Timber.e((String)"Unrecognized connection type: %s", (Object[])new Object[]{connectionType});
                    return;
                }
            }
        }
        this.mavlinkConn.addMavLinkConnectionListener(tag, this.mConnectionListener);
        if (connectionType == 1 && !TextUtils.isEmpty((CharSequence)(pingIpAddress = paramsBundle.getString("extra_udp_ping_receiver_ip")))) {
            try {
                InetAddress resolvedAddress = InetAddress.getByName(pingIpAddress);
                int pingPort = paramsBundle.getInt("extra_udp_ping_receiver_port");
                long pingPeriod = paramsBundle.getLong("extra_udp_ping_period", 10000L);
                byte[] pingPayload = paramsBundle.getByteArray("extra_udp_ping_payload");
                ((AndroidUdpConnection)this.mavlinkConn).addPingTarget(resolvedAddress, pingPort, pingPeriod, pingPayload);
            }
            catch (UnknownHostException e) {
                Timber.e((Throwable)e, (String)"Unable to resolve UDP ping server ip address.", (Object[])new Object[0]);
            }
        }
        if (this.mavlinkConn.getConnectionStatus() == 0) {
            this.mavlinkConn.connect(null);
        }
    }

    @Override
    public synchronized void closeConnection() {
        if (this.isDisconnected()) {
            return;
        }
        this.mavlinkConn.removeMavLinkConnectionListener(this.toString());
        if (this.mavlinkConn.getMavLinkConnectionListenersCount() == 0) {
            Timber.i((String)"Disconnecting...", (Object[])new Object[0]);
            this.mavlinkConn.disconnect();
        }
        this.listener.onConnectionStatus(new LinkConnectionStatus("DISCONNECTED", null));
    }

    @Override
    public Bundle getConnectionExtras() {
        if (this.mavlinkConn == null) {
            return null;
        }
        return this.mavlinkConn.getConnectionExtras();
    }

    @Override
    public synchronized void sendMessage(MAVLinkMessage message, ICommandListener listener) {
        this.sendMavMessage(message, 255, 190, listener);
    }

    protected void sendMavMessage(MAVLinkMessage message, int sysId, int compId, ICommandListener listener) {
        if (this.isDisconnected() || message == null) {
            return;
        }
        MAVLinkPacket packet = message.pack();
        packet.sysid = sysId;
        packet.compid = compId;
        packet.seq = this.packetSeqNumber;
        this.mavlinkConn.sendMavPacket(packet);
        this.packetSeqNumber = (this.packetSeqNumber + 1) % 256;
        if (this.commandTracker != null && listener != null) {
            this.commandTracker.onCommandSubmitted(message, listener);
        }
    }

    public synchronized boolean isDisconnected() {
        return this.getConnectionStatus() == 0;
    }

    @Override
    public synchronized boolean isConnected() {
        return this.getConnectionStatus() == 2;
    }

    private boolean isConnecting() {
        return this.getConnectionStatus() == 1;
    }

    public synchronized void registerForTLogLogging(String appId, Uri tlogLoggingUri) {
        if (tlogLoggingUri == null) {
            return;
        }
        if (this.isConnecting() || this.isConnected()) {
            this.mavlinkConn.addLoggingPath(appId, tlogLoggingUri);
        }
    }

    public synchronized void unregisterForTLogLogging(String appId) {
        if (this.isConnecting() || this.isConnected()) {
            this.mavlinkConn.removeLoggingPath(appId);
        }
    }
}

