/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.communication.connection.usb;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.util.Log;
import com.hoho.android.usbserial.driver.UsbSerialDriver;
import com.hoho.android.usbserial.driver.UsbSerialProber;
import com.o3dr.services.android.lib.gcs.link.LinkConnectionStatus;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.droidplanner.services.android.impl.communication.connection.usb.UsbConnection;
import timber.log.Timber;

class UsbCDCConnection
extends UsbConnection.UsbConnectionImpl {
    private static final String TAG = UsbCDCConnection.class.getSimpleName();
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private static final IntentFilter intentFilter = new IntentFilter("com.android.example.USB_PERMISSION");
    private final AtomicReference<UsbSerialDriver> serialDriverRef = new AtomicReference();
    private final PendingIntent usbPermissionIntent;
    private final BroadcastReceiver broadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (UsbCDCConnection.ACTION_USB_PERMISSION.equals(action)) {
                UsbCDCConnection.this.removeWatchdog();
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                if (intent.getBooleanExtra("permission", false)) {
                    if (device != null) {
                        try {
                            UsbCDCConnection.this.openUsbDevice(device, (Bundle)UsbCDCConnection.this.extrasHolder.get());
                        }
                        catch (IOException e) {
                            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                        }
                    } else {
                        LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-2, "Unable to access usb device.");
                        UsbCDCConnection.this.onUsbConnectionStatus(connectionStatus);
                    }
                } else {
                    Log.d((String)TAG, (String)("permission denied for device " + device));
                    LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-3, "USB Permission denied.");
                    UsbCDCConnection.this.onUsbConnectionStatus(connectionStatus);
                }
            }
        }
    };
    private final Runnable permissionWatchdog = new Runnable(){

        @Override
        public void run() {
            Log.d((String)TAG, (String)"Permission request timeout.");
            LinkConnectionStatus connectionStatus = LinkConnectionStatus.newFailedConnectionStatus(-5, "Unable to get usb access.");
            UsbCDCConnection.this.onUsbConnectionStatus(connectionStatus);
            UsbCDCConnection.this.removeWatchdog();
        }
    };
    private final AtomicReference<Bundle> extrasHolder = new AtomicReference();
    private ScheduledExecutorService scheduler;

    protected UsbCDCConnection(Context context, UsbConnection parentConn, int baudRate) {
        super(context, parentConn, baudRate);
        this.usbPermissionIntent = PendingIntent.getBroadcast((Context)context, (int)0, (Intent)new Intent(ACTION_USB_PERMISSION), (int)0);
    }

    private void registerUsbPermissionBroadcastReceiver() {
        this.mContext.registerReceiver(this.broadcastReceiver, intentFilter);
    }

    private void unregisterUsbPermissionBroadcastReceiver() {
        try {
            this.mContext.unregisterReceiver(this.broadcastReceiver);
        }
        catch (IllegalArgumentException e) {
            Timber.e((Throwable)e, (String)"Receiver was not registered.", (Object[])new Object[0]);
        }
    }

    private void removeWatchdog() {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
    }

    @Override
    protected void openUsbConnection(Bundle extras) throws IOException {
        this.extrasHolder.set(extras);
        this.registerUsbPermissionBroadcastReceiver();
        UsbManager manager = (UsbManager)this.mContext.getSystemService("usb");
        List availableDevices = UsbSerialProber.getAvailableSupportedDevices((UsbManager)manager);
        if (availableDevices.isEmpty()) {
            Log.d((String)TAG, (String)"No Devices found");
            throw new IOException("No Devices found");
        }
        UsbDevice device = (UsbDevice)availableDevices.get(0);
        if (manager.hasPermission(device)) {
            this.openUsbDevice(device, extras);
        } else {
            this.removeWatchdog();
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
            this.scheduler.schedule(this.permissionWatchdog, 15L, TimeUnit.SECONDS);
            Log.d((String)TAG, (String)("Requesting permission to access usb device " + device.getDeviceName()));
            manager.requestPermission(device, this.usbPermissionIntent);
        }
    }

    private void openUsbDevice(UsbDevice device, Bundle extras) throws IOException {
        UsbManager manager = (UsbManager)this.mContext.getSystemService("usb");
        UsbSerialDriver serialDriver = UsbSerialProber.openUsbDevice((UsbManager)manager, (UsbDevice)device);
        if (serialDriver == null) {
            Log.d((String)TAG, (String)"No Devices found");
            throw new IOException("No Devices found");
        }
        Log.d((String)TAG, (String)("Opening using Baud rate " + this.mBaudRate));
        try {
            serialDriver.open();
            serialDriver.setParameters(this.mBaudRate, 8, 1, 0);
            this.serialDriverRef.set(serialDriver);
            this.onUsbConnectionOpened(extras);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Error setting up device: " + e.getMessage()), (Throwable)e);
            try {
                serialDriver.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected int readDataBlock(byte[] readData) throws IOException {
        UsbSerialDriver serialDriver = this.serialDriverRef.get();
        if (serialDriver == null) {
            throw new IOException("Device is unavailable.");
        }
        int iavailable = 0;
        try {
            iavailable = serialDriver.read(readData, 200);
        }
        catch (NullPointerException e) {
            String errorMsg = "Error Reading: " + e.getMessage() + "\nAssuming inaccessible USB device.  Closing connection.";
            Log.e((String)TAG, (String)errorMsg, (Throwable)e);
            throw new IOException(errorMsg, e);
        }
        if (iavailable == 0) {
            iavailable = -1;
        }
        return iavailable;
    }

    @Override
    protected void sendBuffer(byte[] buffer) {
        UsbSerialDriver serialDriver = this.serialDriverRef.get();
        if (serialDriver != null) {
            try {
                serialDriver.write(buffer, 500);
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)("Error Sending: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    protected void closeUsbConnection() throws IOException {
        this.unregisterUsbPermissionBroadcastReceiver();
        UsbSerialDriver serialDriver = this.serialDriverRef.getAndSet(null);
        if (serialDriver != null) {
            try {
                serialDriver.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
    }

    public String toString() {
        return TAG;
    }
}

