/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.property;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;

public class Attitude
implements DroneAttribute {
    private double roll;
    private float rollSpeed;
    private double pitch;
    private float pitchSpeed;
    private double yaw;
    private float yawSpeed;
    public static final Parcelable.Creator<Attitude> CREATOR = new Parcelable.Creator<Attitude>(){

        public Attitude createFromParcel(Parcel source) {
            return new Attitude(source);
        }

        public Attitude[] newArray(int size) {
            return new Attitude[size];
        }
    };

    public Attitude() {
    }

    public Attitude(double roll, double pitch, double yaw, float rollSpeed, float pitchSpeed, float yawSpeed) {
        this.roll = roll;
        this.pitch = pitch;
        this.yaw = yaw;
        this.rollSpeed = rollSpeed;
        this.pitchSpeed = pitchSpeed;
        this.yawSpeed = yawSpeed;
    }

    public void setRoll(double roll) {
        this.roll = roll;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
    }

    public double getRoll() {
        return this.roll;
    }

    public double getPitch() {
        return this.pitch;
    }

    public double getYaw() {
        return this.yaw;
    }

    public float getPitchSpeed() {
        return this.pitchSpeed;
    }

    public void setPitchSpeed(float pitchSpeed) {
        this.pitchSpeed = pitchSpeed;
    }

    public float getRollSpeed() {
        return this.rollSpeed;
    }

    public void setRollSpeed(float rollSpeed) {
        this.rollSpeed = rollSpeed;
    }

    public float getYawSpeed() {
        return this.yawSpeed;
    }

    public void setYawSpeed(float yawSpeed) {
        this.yawSpeed = yawSpeed;
    }

    public String toString() {
        return "Attitude{pitch=" + this.pitch + ", roll=" + this.roll + ", rollSpeed=" + this.rollSpeed + ", pitchSpeed=" + this.pitchSpeed + ", yaw=" + this.yaw + ", yawSpeed=" + this.yawSpeed + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attitude)) {
            return false;
        }
        Attitude attitude = (Attitude)o;
        if (Double.compare(attitude.roll, this.roll) != 0) {
            return false;
        }
        if (Float.compare(attitude.rollSpeed, this.rollSpeed) != 0) {
            return false;
        }
        if (Double.compare(attitude.pitch, this.pitch) != 0) {
            return false;
        }
        if (Float.compare(attitude.pitchSpeed, this.pitchSpeed) != 0) {
            return false;
        }
        if (Double.compare(attitude.yaw, this.yaw) != 0) {
            return false;
        }
        return Float.compare(attitude.yawSpeed, this.yawSpeed) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.roll);
        int result = (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.rollSpeed != 0.0f ? Float.floatToIntBits(this.rollSpeed) : 0);
        temp = Double.doubleToLongBits(this.pitch);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.pitchSpeed != 0.0f ? Float.floatToIntBits(this.pitchSpeed) : 0);
        temp = Double.doubleToLongBits(this.yaw);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.yawSpeed != 0.0f ? Float.floatToIntBits(this.yawSpeed) : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.roll);
        dest.writeDouble(this.pitch);
        dest.writeDouble(this.yaw);
        dest.writeFloat(this.rollSpeed);
        dest.writeFloat(this.pitchSpeed);
        dest.writeFloat(this.yawSpeed);
    }

    private Attitude(Parcel in) {
        this.roll = in.readDouble();
        this.pitch = in.readDouble();
        this.yaw = in.readDouble();
        this.rollSpeed = in.readFloat();
        this.pitchSpeed = in.readFloat();
        this.yawSpeed = in.readFloat();
    }
}

