/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission.item.spatial;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.mission.MissionItemType;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.mission.item.spatial.BaseSpatialItem;

public class SplineWaypoint
extends BaseSpatialItem
implements Parcelable {
    private double delay;
    public static final Parcelable.Creator<SplineWaypoint> CREATOR = new Parcelable.Creator<SplineWaypoint>(){

        public SplineWaypoint createFromParcel(Parcel source) {
            return new SplineWaypoint(source);
        }

        public SplineWaypoint[] newArray(int size) {
            return new SplineWaypoint[size];
        }
    };

    public SplineWaypoint() {
        super(MissionItemType.SPLINE_WAYPOINT);
    }

    public SplineWaypoint(SplineWaypoint copy) {
        super(copy);
        this.delay = copy.delay;
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double delay) {
        this.delay = delay;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeDouble(this.delay);
    }

    private SplineWaypoint(Parcel in) {
        super(in);
        this.delay = in.readDouble();
    }

    @Override
    public String toString() {
        return "SplineWaypoint{delay=" + this.delay + ", " + super.toString() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SplineWaypoint)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SplineWaypoint that = (SplineWaypoint)o;
        return Double.compare(that.delay, this.delay) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.delay);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public MissionItem clone() {
        return new SplineWaypoint(this);
    }
}

