/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission.item.complex;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.mission.item.complex.CameraDetail;

public class SurveyDetail
implements Parcelable {
    private double altitude;
    private double angle;
    private double overlap;
    private double sidelap;
    private boolean lockOrientation;
    private CameraDetail cameraDetail;
    public static final Parcelable.Creator<SurveyDetail> CREATOR = new Parcelable.Creator<SurveyDetail>(){

        public SurveyDetail createFromParcel(Parcel source) {
            return new SurveyDetail(source);
        }

        public SurveyDetail[] newArray(int size) {
            return new SurveyDetail[size];
        }
    };

    public double getAltitude() {
        return this.altitude;
    }

    public void setAltitude(double altitude) {
        this.altitude = altitude;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getOverlap() {
        return this.overlap;
    }

    public void setOverlap(double overlap) {
        this.overlap = overlap;
    }

    public double getSidelap() {
        return this.sidelap;
    }

    public void setSidelap(double sidelap) {
        this.sidelap = sidelap;
    }

    public CameraDetail getCameraDetail() {
        return this.cameraDetail;
    }

    public void setCameraDetail(CameraDetail cameraDetail) {
        this.cameraDetail = cameraDetail;
    }

    public boolean getLockOrientation() {
        return this.lockOrientation;
    }

    public void setLockOrientation(boolean lockOrientation) {
        this.lockOrientation = lockOrientation;
    }

    public double getLateralFootPrint() {
        return this.altitude * this.cameraDetail.getSensorLateralSize() / this.cameraDetail.getFocalLength();
    }

    public double getLongitudinalFootPrint() {
        return this.altitude * this.cameraDetail.getSensorLongitudinalSize() / this.cameraDetail.getFocalLength();
    }

    public double getGroundResolution() {
        return this.altitude * this.cameraDetail.getSensorLateralSize() / this.cameraDetail.getFocalLength() * (this.altitude * this.cameraDetail.getSensorLongitudinalSize() / this.cameraDetail.getFocalLength()) / (this.cameraDetail.getSensorResolution() * 1000.0) / 10000.0;
    }

    public double getLongitudinalPictureDistance() {
        return this.getLongitudinalFootPrint() * (1.0 - this.overlap * 0.01);
    }

    public double getLateralPictureDistance() {
        return this.getLateralFootPrint() * (1.0 - this.sidelap * 0.01);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.altitude);
        dest.writeDouble(this.angle);
        dest.writeDouble(this.overlap);
        dest.writeDouble(this.sidelap);
        dest.writeParcelable((Parcelable)this.cameraDetail, 0);
        dest.writeByte((byte)(this.lockOrientation ? 1 : 0));
    }

    public SurveyDetail() {
    }

    public SurveyDetail(SurveyDetail copy) {
        this.altitude = copy.altitude;
        this.angle = copy.angle;
        this.overlap = copy.overlap;
        this.sidelap = copy.sidelap;
        this.lockOrientation = copy.lockOrientation;
        this.cameraDetail = copy.cameraDetail == null ? null : new CameraDetail(copy.cameraDetail);
    }

    private SurveyDetail(Parcel in) {
        this.altitude = in.readDouble();
        this.angle = in.readDouble();
        this.overlap = in.readDouble();
        this.sidelap = in.readDouble();
        this.cameraDetail = (CameraDetail)in.readParcelable(CameraDetail.class.getClassLoader());
        this.lockOrientation = in.readByte() != 0;
    }
}

