/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission.item.complex;

import android.os.Parcel;
import android.os.Parcelable;

public class CameraDetail
implements Parcelable {
    private final String name;
    private final double sensorWidth;
    private final double sensorHeight;
    private final double sensorResolution;
    private final double focalLength;
    private final double overlap;
    private final double sidelap;
    private final boolean isInLandscapeOrientation;
    public static final Parcelable.Creator<CameraDetail> CREATOR = new Parcelable.Creator<CameraDetail>(){

        public CameraDetail createFromParcel(Parcel source) {
            return new CameraDetail(source);
        }

        public CameraDetail[] newArray(int size) {
            return new CameraDetail[size];
        }
    };

    public CameraDetail() {
        this.name = "Canon SX260";
        this.sensorWidth = 6.12;
        this.sensorHeight = 4.22;
        this.sensorResolution = 12.1;
        this.focalLength = 5.0;
        this.overlap = 50.0;
        this.sidelap = 60.0;
        this.isInLandscapeOrientation = true;
    }

    public CameraDetail(String name, double sensorWidth, double sensorHeight, double sensorResolution, double focalLength, double overlap, double sidelap, boolean isInLandscapeOrientation) {
        this.name = name;
        this.sensorWidth = sensorWidth;
        this.sensorHeight = sensorHeight;
        this.sensorResolution = sensorResolution;
        this.focalLength = focalLength;
        this.overlap = overlap;
        this.sidelap = sidelap;
        this.isInLandscapeOrientation = isInLandscapeOrientation;
    }

    public CameraDetail(CameraDetail copy) {
        this(copy.name, copy.sensorWidth, copy.sensorHeight, copy.sensorResolution, copy.focalLength, copy.overlap, copy.sidelap, copy.isInLandscapeOrientation);
    }

    public String getName() {
        return this.name;
    }

    public double getSensorWidth() {
        return this.sensorWidth;
    }

    public double getSensorHeight() {
        return this.sensorHeight;
    }

    public double getSensorResolution() {
        return this.sensorResolution;
    }

    public double getFocalLength() {
        return this.focalLength;
    }

    public double getOverlap() {
        return this.overlap;
    }

    public double getSidelap() {
        return this.sidelap;
    }

    public boolean isInLandscapeOrientation() {
        return this.isInLandscapeOrientation;
    }

    public Double getSensorLateralSize() {
        if (this.isInLandscapeOrientation) {
            return this.sensorWidth;
        }
        return this.sensorHeight;
    }

    public Double getSensorLongitudinalSize() {
        if (this.isInLandscapeOrientation) {
            return this.sensorHeight;
        }
        return this.sensorWidth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CameraDetail)) {
            return false;
        }
        CameraDetail that = (CameraDetail)o;
        if (Double.compare(that.focalLength, this.focalLength) != 0) {
            return false;
        }
        if (this.isInLandscapeOrientation != that.isInLandscapeOrientation) {
            return false;
        }
        if (Double.compare(that.overlap, this.overlap) != 0) {
            return false;
        }
        if (Double.compare(that.sensorHeight, this.sensorHeight) != 0) {
            return false;
        }
        if (Double.compare(that.sensorResolution, this.sensorResolution) != 0) {
            return false;
        }
        if (Double.compare(that.sensorWidth, this.sensorWidth) != 0) {
            return false;
        }
        if (Double.compare(that.sidelap, this.sidelap) != 0) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        long temp = Double.doubleToLongBits(this.sensorWidth);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.sensorHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.sensorResolution);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.focalLength);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.overlap);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.sidelap);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isInLandscapeOrientation ? 1 : 0);
        return result;
    }

    public String toString() {
        return "CameraDetail{name='" + this.name + '\'' + ", sensorWidth=" + this.sensorWidth + ", sensorHeight=" + this.sensorHeight + ", sensorResolution=" + this.sensorResolution + ", focalLength=" + this.focalLength + ", overlap=" + this.overlap + ", sidelap=" + this.sidelap + ", isInLandscapeOrientation=" + this.isInLandscapeOrientation + '}';
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.name);
        dest.writeDouble(this.sensorWidth);
        dest.writeDouble(this.sensorHeight);
        dest.writeDouble(this.sensorResolution);
        dest.writeDouble(this.focalLength);
        dest.writeDouble(this.overlap);
        dest.writeDouble(this.sidelap);
        dest.writeByte(this.isInLandscapeOrientation ? (byte)1 : 0);
    }

    private CameraDetail(Parcel in) {
        this.name = in.readString();
        this.sensorWidth = in.readDouble();
        this.sensorHeight = in.readDouble();
        this.sensorResolution = in.readDouble();
        this.focalLength = in.readDouble();
        this.overlap = in.readDouble();
        this.sidelap = in.readDouble();
        this.isInLandscapeOrientation = in.readByte() != 0;
    }
}

