/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.mission;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.mission.MissionItemType;
import com.o3dr.services.android.lib.drone.mission.item.MissionItem;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import java.util.ArrayList;
import java.util.List;

public class Mission
implements DroneAttribute {
    private int currentMissionItem;
    private final List<MissionItem> missionItemsList = new ArrayList<MissionItem>();
    public static final Parcelable.Creator<Mission> CREATOR = new Parcelable.Creator<Mission>(){

        public Mission createFromParcel(Parcel source) {
            return new Mission(source);
        }

        public Mission[] newArray(int size) {
            return new Mission[size];
        }
    };

    public Mission() {
    }

    public void addMissionItem(MissionItem missionItem) {
        this.missionItemsList.add(missionItem);
    }

    public void addMissionItem(int index, MissionItem missionItem) {
        this.missionItemsList.add(index, missionItem);
    }

    public void removeMissionItem(MissionItem missionItem) {
        this.missionItemsList.remove(missionItem);
    }

    public void removeMissionItem(int index) {
        this.missionItemsList.remove(index);
    }

    public void clear() {
        this.missionItemsList.clear();
    }

    public MissionItem getMissionItem(int index) {
        return this.missionItemsList.get(index);
    }

    public List<MissionItem> getMissionItems() {
        return this.missionItemsList;
    }

    public int getCurrentMissionItem() {
        return this.currentMissionItem;
    }

    public void setCurrentMissionItem(int currentMissionItem) {
        this.currentMissionItem = currentMissionItem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Mission)) {
            return false;
        }
        Mission mission = (Mission)o;
        if (this.currentMissionItem != mission.currentMissionItem) {
            return false;
        }
        return this.missionItemsList.equals(mission.missionItemsList);
    }

    public int hashCode() {
        int result = this.currentMissionItem;
        result = 31 * result + this.missionItemsList.hashCode();
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.currentMissionItem);
        ArrayList<Bundle> missionItemsBundles = new ArrayList<Bundle>(this.missionItemsList.size());
        if (!this.missionItemsList.isEmpty()) {
            for (MissionItem missionItem : this.missionItemsList) {
                missionItemsBundles.add(missionItem.getType().storeMissionItem(missionItem));
            }
        }
        dest.writeTypedList(missionItemsBundles);
    }

    private Mission(Parcel in) {
        this.currentMissionItem = in.readInt();
        ArrayList missionItemsBundles = new ArrayList();
        in.readTypedList(missionItemsBundles, Bundle.CREATOR);
        if (!missionItemsBundles.isEmpty()) {
            for (Bundle bundle : missionItemsBundles) {
                this.missionItemsList.add((MissionItem)MissionItemType.restoreMissionItemFromBundle(bundle));
            }
        }
    }
}

