/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloShotOptions;
import java.nio.ByteBuffer;

public class SoloZiplineOptions
extends SoloShotOptions {
    public static final int MESSAGE_LENGTH = 6;
    private boolean is3D;
    private boolean cameraLock;
    public static final Parcelable.Creator<SoloZiplineOptions> CREATOR = new Parcelable.Creator<SoloZiplineOptions>(){

        public SoloZiplineOptions createFromParcel(Parcel source) {
            return new SoloZiplineOptions(source);
        }

        public SoloZiplineOptions[] newArray(int size) {
            return new SoloZiplineOptions[size];
        }
    };

    public boolean is3D() {
        return this.is3D;
    }

    public void setIs3D(boolean is3D) {
        this.is3D = is3D;
    }

    public boolean isCameraLock() {
        return this.cameraLock;
    }

    public void setCameraLock(boolean cameraLock) {
        this.cameraLock = cameraLock;
    }

    public SoloZiplineOptions(float cruiseSpeed, boolean is3D, boolean cameraLock) {
        super(23, 6, cruiseSpeed);
        this.is3D = is3D;
        this.cameraLock = cameraLock;
    }

    SoloZiplineOptions(ByteBuffer buffer) {
        this(buffer.getFloat(), buffer.get() == 1, buffer.get() == 1);
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        super.getMessageValue(valueCarrier);
        valueCarrier.put((byte)(this.is3D ? 1 : 0));
        valueCarrier.put((byte)(this.cameraLock ? 1 : 0));
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeByte(this.is3D ? (byte)1 : 0);
        dest.writeByte(this.cameraLock ? (byte)1 : 0);
    }

    protected SoloZiplineOptions(Parcel in) {
        super(in);
        this.is3D = in.readByte() != 0;
        this.cameraLock = in.readByte() != 0;
    }

    @Override
    public String toString() {
        return "SoloZiplineOptions{cruiseSpeed=" + this.getCruiseSpeed() + "is3D=" + this.is3D + "cameraLock=" + this.cameraLock + '}';
    }
}

