/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.companion.solo.tlv;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloShotOptions;
import java.nio.ByteBuffer;

public class SoloCableCamOptions
extends SoloShotOptions {
    private static final int CAM_INTERPOLATION_ENABLED_VALUE = 1;
    private static final int CAM_INTERPOLATION_DISABLED_VALUE = 0;
    private static final int YAW_DIRECTION_CW_VALUE = 0;
    private static final int YAW_DIRECTION_CCW_VALUE = 1;
    private boolean camInterpolation;
    private boolean yawDirectionClockwise;
    public static final Parcelable.Creator<SoloCableCamOptions> CREATOR = new Parcelable.Creator<SoloCableCamOptions>(){

        public SoloCableCamOptions createFromParcel(Parcel source) {
            return new SoloCableCamOptions(source);
        }

        public SoloCableCamOptions[] newArray(int size) {
            return new SoloCableCamOptions[size];
        }
    };

    public SoloCableCamOptions(boolean camInterpolation, boolean yawDirectionClockwise, float cruiseSpeed) {
        super(4, 8, cruiseSpeed);
        this.camInterpolation = camInterpolation;
        this.yawDirectionClockwise = yawDirectionClockwise;
    }

    SoloCableCamOptions(int camInterpolationValue, int yawDirectionValue, float cruiseSpeed) {
        this(camInterpolationValue == 1, yawDirectionValue == 0, cruiseSpeed);
    }

    public boolean isCamInterpolationOn() {
        return this.camInterpolation;
    }

    public void setCamInterpolation(boolean camInterpolation) {
        this.camInterpolation = camInterpolation;
    }

    public boolean isYawDirectionClockWise() {
        return this.yawDirectionClockwise;
    }

    public void setYawDirection(boolean yawDirection) {
        this.yawDirectionClockwise = yawDirection;
    }

    @Override
    protected void getMessageValue(ByteBuffer valueCarrier) {
        valueCarrier.putShort((short)(this.camInterpolation ? 1 : 0));
        valueCarrier.putShort((short)(!this.yawDirectionClockwise ? 1 : 0));
        super.getMessageValue(valueCarrier);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeByte(this.camInterpolation ? (byte)1 : 0);
        dest.writeByte(this.yawDirectionClockwise ? (byte)1 : 0);
    }

    protected SoloCableCamOptions(Parcel in) {
        super(in);
        this.camInterpolation = in.readByte() != 0;
        this.yawDirectionClockwise = in.readByte() != 0;
    }
}

