/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.services.android.lib.drone.calibration.magnetometer;

import android.os.Parcel;
import android.os.Parcelable;
import com.o3dr.services.android.lib.drone.calibration.magnetometer.MagnetometerCalibrationProgress;
import com.o3dr.services.android.lib.drone.calibration.magnetometer.MagnetometerCalibrationResult;
import com.o3dr.services.android.lib.drone.property.DroneAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MagnetometerCalibrationStatus
implements DroneAttribute {
    private final Map<Integer, MagnetometerCalibrationProgress> calibrationProgressTracker = new HashMap<Integer, MagnetometerCalibrationProgress>();
    private final Map<Integer, MagnetometerCalibrationResult> calibrationResultTracker = new HashMap<Integer, MagnetometerCalibrationResult>();
    private final List<Integer> compassList = new ArrayList<Integer>();
    private boolean calibrationCancelled;
    public static final Parcelable.Creator<MagnetometerCalibrationStatus> CREATOR = new Parcelable.Creator<MagnetometerCalibrationStatus>(){

        public MagnetometerCalibrationStatus createFromParcel(Parcel source) {
            return new MagnetometerCalibrationStatus(source);
        }

        public MagnetometerCalibrationStatus[] newArray(int size) {
            return new MagnetometerCalibrationStatus[size];
        }
    };

    public MagnetometerCalibrationStatus() {
    }

    public void addCalibrationProgress(MagnetometerCalibrationProgress progress) {
        if (progress != null) {
            int compassId = progress.getCompassId();
            this.calibrationProgressTracker.put(compassId, progress);
            this.compassList.add(compassId);
        }
    }

    public void addCalibrationResult(MagnetometerCalibrationResult result) {
        if (result != null) {
            int compassId = result.getCompassId();
            this.calibrationResultTracker.put(result.getCompassId(), result);
            this.compassList.add(compassId);
        }
    }

    public List<Integer> getCompassIds() {
        return this.compassList;
    }

    public MagnetometerCalibrationProgress getCalibrationProgress(int compassId) {
        return this.calibrationProgressTracker.get(compassId);
    }

    public MagnetometerCalibrationResult getCalibrationResult(int compassId) {
        return this.calibrationResultTracker.get(compassId);
    }

    public boolean isCalibrationCancelled() {
        return this.calibrationCancelled;
    }

    public void setCalibrationCancelled(boolean calibrationCancelled) {
        this.calibrationCancelled = calibrationCancelled;
    }

    public boolean isCalibrationComplete() {
        for (Integer compassId : this.compassList) {
            if (this.calibrationResultTracker.containsKey(compassId)) continue;
            return false;
        }
        return true;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        ArrayList<MagnetometerCalibrationProgress> progressList = new ArrayList<MagnetometerCalibrationProgress>(this.calibrationProgressTracker.values());
        dest.writeTypedList(progressList);
        ArrayList<MagnetometerCalibrationResult> resultList = new ArrayList<MagnetometerCalibrationResult>(this.calibrationResultTracker.values());
        dest.writeTypedList(resultList);
        dest.writeByte(this.calibrationCancelled ? (byte)1 : 0);
    }

    private MagnetometerCalibrationStatus(Parcel in) {
        ArrayList progressList = new ArrayList();
        in.readTypedList(progressList, MagnetometerCalibrationProgress.CREATOR);
        for (MagnetometerCalibrationProgress progress : progressList) {
            this.addCalibrationProgress(progress);
        }
        ArrayList resultList = new ArrayList();
        in.readTypedList(resultList, MagnetometerCalibrationResult.CREATOR);
        for (MagnetometerCalibrationResult result : resultList) {
            this.addCalibrationResult(result);
        }
        this.calibrationCancelled = in.readByte() != 0;
    }
}

