/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.video;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.Surface;
import com.o3dr.android.client.utils.video.DecoderListener;
import com.o3dr.android.client.utils.video.NaluChunk;
import com.o3dr.android.client.utils.video.NaluChunkAssembler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

@TargetApi(value=18)
public class MediaCodecManager {
    private static final String TAG = MediaCodecManager.class.getSimpleName();
    private static final String MIME_TYPE = "video/avc";
    public static final int DEFAULT_VIDEO_WIDTH = 1920;
    public static final int DEFAULT_VIDEO_HEIGHT = 1080;
    private final Runnable stopSafely = new Runnable(){

        @Override
        public void run() {
            MediaCodecManager.this.processInputData.set(false);
            MediaCodecManager.this.sendCompletionFlag.set(false);
            MediaCodecManager.this.naluChunkAssembler.reset();
            if (MediaCodecManager.this.dequeueRunner != null && MediaCodecManager.this.dequeueRunner.isAlive()) {
                Log.d((String)TAG, (String)"Interrupting dequeue runner thread.");
                MediaCodecManager.this.dequeueRunner.interrupt();
            }
            MediaCodecManager.this.dequeueRunner = null;
            MediaCodec mediaCodec = (MediaCodec)MediaCodecManager.this.mediaCodecRef.get();
            if (mediaCodec != null) {
                try {
                    mediaCodec.stop();
                }
                catch (IllegalStateException e) {
                    Log.e((String)TAG, (String)"Error while stopping media codec.", (Throwable)e);
                }
                mediaCodec.release();
                MediaCodecManager.this.mediaCodecRef.set(null);
            }
            MediaCodecManager.this.surfaceRef.set(null);
            MediaCodecManager.this.isDecoding.set(false);
            MediaCodecManager.this.handler.post(MediaCodecManager.this.decodingEndedNotification);
        }
    };
    private final Runnable decodingStartedNotification = new Runnable(){

        @Override
        public void run() {
            DecoderListener listener = (DecoderListener)MediaCodecManager.this.decoderListenerRef.get();
            if (listener != null) {
                listener.onDecodingStarted();
            }
        }
    };
    private final Runnable decodingErrorNotification = new Runnable(){

        @Override
        public void run() {
            DecoderListener listener = (DecoderListener)MediaCodecManager.this.decoderListenerRef.get();
            if (listener != null) {
                listener.onDecodingError();
            }
        }
    };
    private final Runnable decodingEndedNotification = new Runnable(){

        @Override
        public void run() {
            DecoderListener listener = (DecoderListener)MediaCodecManager.this.decoderListenerRef.get();
            if (listener != null) {
                listener.onDecodingEnded();
            }
        }
    };
    private final AtomicBoolean decodedFirstFrame = new AtomicBoolean(false);
    private final AtomicBoolean isDecoding = new AtomicBoolean(false);
    private final AtomicBoolean processInputData = new AtomicBoolean(false);
    private final AtomicBoolean sendCompletionFlag = new AtomicBoolean(false);
    private final AtomicReference<Surface> surfaceRef = new AtomicReference();
    private final AtomicReference<MediaCodec> mediaCodecRef = new AtomicReference();
    private final AtomicReference<DecoderListener> decoderListenerRef = new AtomicReference();
    private final NaluChunkAssembler naluChunkAssembler;
    private final Handler handler;
    private final AtomicReference<NaluChunkListener> naluChunkListenerRef = new AtomicReference();
    private DequeueCodec dequeueRunner;

    public MediaCodecManager(Handler handler) {
        this.handler = handler;
        this.naluChunkAssembler = new NaluChunkAssembler();
    }

    public void setNaluChunkListener(NaluChunkListener naluChunkListener) {
        this.naluChunkListenerRef.set(naluChunkListener);
    }

    public Surface getSurface() {
        return this.surfaceRef.get();
    }

    public void startDecoding(Surface surface, DecoderListener listener) throws IOException {
        if (surface == null) {
            throw new IllegalStateException("Surface argument must be non-null.");
        }
        if (this.isDecoding.compareAndSet(false, true)) {
            Log.i((String)TAG, (String)"Starting decoding...");
            this.naluChunkAssembler.reset();
            this.decoderListenerRef.set(listener);
            MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)MIME_TYPE, (int)1920, (int)1080);
            MediaCodec mediaCodec = MediaCodec.createDecoderByType((String)MIME_TYPE);
            mediaCodec.configure(mediaFormat, surface, null, 0);
            mediaCodec.start();
            this.surfaceRef.set(surface);
            this.mediaCodecRef.set(mediaCodec);
            this.processInputData.set(true);
            this.dequeueRunner = new DequeueCodec();
            this.dequeueRunner.start();
        }
    }

    public void stopDecoding(DecoderListener listener) {
        Log.i((String)TAG, (String)"Stopping input data processing...");
        this.decoderListenerRef.set(listener);
        if (!this.isDecoding.get()) {
            if (listener != null) {
                this.notifyDecodingEnded();
            }
        } else if (this.decodedFirstFrame.get()) {
            if (this.processInputData.compareAndSet(true, false)) {
                this.sendCompletionFlag.set(!this.processNALUChunk(this.naluChunkAssembler.getEndOfStream()));
            }
        } else {
            this.handler.post(this.stopSafely);
        }
    }

    public void onInputDataReceived(byte[] data, int dataSize) {
        if (this.isDecoding.get()) {
            if (this.processInputData.get()) {
                NaluChunk naluChunk = this.naluChunkAssembler.assembleNALUChunk(data, dataSize);
                if (naluChunk != null) {
                    this.processNALUChunk(naluChunk);
                }
            } else if (this.sendCompletionFlag.get()) {
                Log.d((String)TAG, (String)"Sending end of stream data.");
                this.sendCompletionFlag.set(!this.processNALUChunk(this.naluChunkAssembler.getEndOfStream()));
            }
        }
    }

    private boolean processNALUChunk(NaluChunk naluChunk) {
        if (naluChunk == null) {
            return false;
        }
        MediaCodec mediaCodec = this.mediaCodecRef.get();
        if (mediaCodec == null) {
            return false;
        }
        try {
            int index = mediaCodec.dequeueInputBuffer(-1L);
            if (index >= 0) {
                ByteBuffer inputBuffer = Build.VERSION.SDK_INT >= 21 ? mediaCodec.getInputBuffer(index) : mediaCodec.getInputBuffers()[index];
                if (inputBuffer == null) {
                    return false;
                }
                inputBuffer.clear();
                int totalLength = 0;
                for (ByteBuffer payload : naluChunk.payloads) {
                    if (payload.capacity() == 0) continue;
                    inputBuffer.order(payload.order());
                    int dataLength = payload.position();
                    byte[] payloadData = payload.array();
                    inputBuffer.put(payloadData, 0, dataLength);
                    totalLength += dataLength;
                }
                NaluChunkListener naluChunkListener = this.naluChunkListenerRef.get();
                if (naluChunkListener != null) {
                    naluChunkListener.onNaluChunkUpdated(this.naluChunkAssembler.getParametersSet(), naluChunk);
                }
                mediaCodec.queueInputBuffer(index, 0, totalLength, naluChunk.presentationTime, naluChunk.flags);
            }
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private void notifyDecodingStarted() {
        this.handler.post(this.decodingStartedNotification);
    }

    private void notifyDecodingError() {
        this.handler.post(this.decodingErrorNotification);
    }

    private void notifyDecodingEnded() {
        this.handler.post(this.stopSafely);
    }

    private class DequeueCodec
    extends Thread {
        private DequeueCodec() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MediaCodec mediaCodec = (MediaCodec)MediaCodecManager.this.mediaCodecRef.get();
            if (mediaCodec == null) {
                throw new IllegalStateException("Start decoding hasn't been called yet.");
            }
            Log.i((String)TAG, (String)"Starting dequeue codec runner.");
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            MediaCodecManager.this.decodedFirstFrame.set(false);
            boolean continueDequeue = true;
            try {
                while (continueDequeue) {
                    int index = mediaCodec.dequeueOutputBuffer(info, -1L);
                    if (index < 0) continue;
                    boolean doRender = info.size != 0;
                    mediaCodec.releaseOutputBuffer(index, doRender);
                    if (MediaCodecManager.this.decodedFirstFrame.compareAndSet(false, true)) {
                        MediaCodecManager.this.notifyDecodingStarted();
                        Log.i((String)TAG, (String)("Received first decoded frame of size " + info.size));
                    }
                    if (continueDequeue = (info.flags & 4) == 0) continue;
                    Log.i((String)TAG, (String)"Received end of stream flag.");
                }
            }
            catch (IllegalStateException e) {
                if (!this.isInterrupted()) {
                    Log.e((String)TAG, (String)"Decoding error!", (Throwable)e);
                    MediaCodecManager.this.notifyDecodingError();
                }
            }
            finally {
                if (!this.isInterrupted()) {
                    MediaCodecManager.this.notifyDecodingEnded();
                }
                Log.i((String)TAG, (String)"Stopping dequeue codec runner.");
            }
        }
    }

    public static interface NaluChunkListener {
        public void onNaluChunkUpdated(NaluChunk var1, NaluChunk var2);
    }
}

