/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.utils.geotag;

import android.util.Log;
import com.MAVLink.Messages.MAVLinkMessage;
import com.MAVLink.ardupilotmega.msg_camera_feedback;
import com.MAVLink.common.msg_named_value_int;
import com.o3dr.android.client.utils.data.tlog.TLogParser;
import com.o3dr.android.client.utils.geotag.GeoTagAsyncTask;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class FilterByTimestampGeoTagAlgorithm
implements GeoTagAsyncTask.GeoTagAlgorithm {
    private static final String TAG = FilterByTimestampGeoTagAlgorithm.class.getSimpleName();

    @Override
    public HashMap<TLogParser.Event, File> match(List<TLogParser.Event> events, ArrayList<File> photos) {
        if (events.isEmpty() || photos.isEmpty()) {
            return null;
        }
        TreeMap<Long, TLogParser.Event> sortedEvents = new TreeMap<Long, TLogParser.Event>();
        TreeMap<Long, File> filteredPhotos = new TreeMap<Long, File>();
        TLogParser.Event startEvent = null;
        for (TLogParser.Event event : events) {
            MAVLinkMessage eventMsg = event.getMavLinkMessage();
            if (eventMsg instanceof msg_camera_feedback) {
                sortedEvents.put(event.getTimestamp(), event);
                continue;
            }
            if (!(eventMsg instanceof msg_named_value_int)) continue;
            if (startEvent == null) {
                startEvent = event;
                continue;
            }
            Log.w((String)TAG, (String)"There's more than one msg_named_value_int event in the event list.");
            if (startEvent.getTimestamp() <= event.getTimestamp()) continue;
            startEvent = event;
        }
        if (startEvent == null) {
            return null;
        }
        long startTime = startEvent.getTimestamp();
        Log.i((String)TAG, (String)("Filtering events for mission " + ((msg_named_value_int)startEvent.getMavLinkMessage()).getName() + " with start time " + startTime));
        SortedMap filteredEvents = sortedEvents.tailMap(startTime);
        if (filteredEvents.isEmpty()) {
            return null;
        }
        long endTime = filteredEvents.lastKey();
        if (endTime <= startTime) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        long timezoneOffset = calendar.get(15) + calendar.get(16);
        for (File photo : photos) {
            long modifiedTime = photo.lastModified();
            long updatedTime = modifiedTime + timezoneOffset;
            if (startTime > updatedTime || updatedTime > endTime) continue;
            filteredPhotos.put(modifiedTime, photo);
        }
        if (filteredPhotos.isEmpty()) {
            return null;
        }
        HashMap<TLogParser.Event, File> result = new HashMap<TLogParser.Event, File>();
        ArrayList eventCollection = new ArrayList(sortedEvents.values());
        int eventSize = eventCollection.size();
        ArrayList photoCollection = new ArrayList(filteredPhotos.values());
        int photoSize = photoCollection.size();
        int e = 0;
        for (int p = 0; e < eventSize && p < photoSize; ++e, ++p) {
            result.put((TLogParser.Event)eventCollection.get(e), (File)photoCollection.get(p));
        }
        return result;
    }
}

