/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis.solo;

import android.os.Bundle;
import android.view.Surface;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.android.client.apis.CameraApi;
import com.o3dr.android.client.apis.CapabilityApi;
import com.o3dr.android.client.apis.solo.SoloApi;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproRecord;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproSetExtendedRequest;
import com.o3dr.services.android.lib.drone.companion.solo.tlv.SoloGoproSetRequest;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;

public class SoloCameraApi
extends SoloApi {
    private static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.US);
    private static final ConcurrentHashMap<Drone, SoloCameraApi> soloCameraApiCache = new ConcurrentHashMap();
    private static final Api.Builder<SoloCameraApi> apiBuilder = new Api.Builder<SoloCameraApi>(){

        @Override
        public SoloCameraApi build(Drone drone) {
            return new SoloCameraApi(drone);
        }
    };
    private static final int SOLO_STREAM_UDP_PORT = 5600;
    private final CapabilityApi capabilityChecker;
    private final CameraApi cameraApi;

    public static SoloCameraApi getApi(Drone drone) {
        return SoloCameraApi.getApi(drone, soloCameraApiCache, apiBuilder);
    }

    private SoloCameraApi(Drone drone) {
        super(drone);
        this.capabilityChecker = CapabilityApi.getApi(drone);
        this.cameraApi = CameraApi.getApi(drone);
    }

    public void takePhoto(final AbstractCommandListener listener) {
        this.switchCameraCaptureMode((byte)1, new AbstractCommandListener(){

            @Override
            public void onSuccess() {
                SoloGoproRecord photoRecord = new SoloGoproRecord(1);
                SoloCameraApi.this.sendMessage(photoRecord, listener);
            }

            @Override
            public void onError(int executionError) {
                if (listener != null) {
                    listener.onError(executionError);
                }
            }

            @Override
            public void onTimeout() {
                if (listener != null) {
                    listener.onTimeout();
                }
            }
        });
    }

    public void toggleVideoRecording(AbstractCommandListener listener) {
        this.sendVideoRecordingCommand(2, listener);
    }

    public void startVideoRecording(AbstractCommandListener listener) {
        this.sendVideoRecordingCommand(1, listener);
    }

    public void stopVideoRecording(AbstractCommandListener listener) {
        this.sendVideoRecordingCommand(0, listener);
    }

    private void sendVideoRecordingCommand(final int recordCommand, final AbstractCommandListener listener) {
        this.switchCameraCaptureMode((byte)0, new AbstractCommandListener(){

            @Override
            public void onSuccess() {
                SoloGoproRecord videoToggle = new SoloGoproRecord(recordCommand);
                SoloCameraApi.this.sendMessage(videoToggle, listener);
            }

            @Override
            public void onError(int executionError) {
                if (listener != null) {
                    listener.onError(executionError);
                }
            }

            @Override
            public void onTimeout() {
                if (listener != null) {
                    listener.onTimeout();
                }
            }
        });
    }

    public void startVideoStream(Surface surface, String tag, AbstractCommandListener listener) {
        this.startVideoStream(surface, tag, false, listener);
    }

    public void startVideoStream(final Surface surface, final String tag, final boolean enableLocalRecording, final AbstractCommandListener listener) {
        if (surface == null) {
            SoloCameraApi.postErrorEvent(4, listener);
            return;
        }
        this.capabilityChecker.checkFeatureSupport("feature_solo_video_streaming", new CapabilityApi.FeatureSupportListener(){

            @Override
            public void onFeatureSupportResult(String featureId, int result, Bundle resultInfo) {
                switch (result) {
                    case 0: {
                        Bundle videoProps = new Bundle();
                        videoProps.putInt("extra_video_props_udp_port", 5600);
                        videoProps.putBoolean("extra_video_enable_local_recording", enableLocalRecording);
                        if (enableLocalRecording) {
                            String localRecordingFilename = "solo_stream_" + FILE_DATE_FORMAT.format(new Date());
                            videoProps.putString("extra_video_local_recording_filename", localRecordingFilename);
                        }
                        SoloCameraApi.this.cameraApi.startVideoStream(surface, tag, videoProps, listener);
                        break;
                    }
                    case 1: {
                        SoloCameraApi.postErrorEvent(3, listener);
                        break;
                    }
                    default: {
                        SoloCameraApi.postErrorEvent(4, listener);
                    }
                }
            }
        });
    }

    public void startVideoStream(Surface surface, AbstractCommandListener listener) {
        this.startVideoStream(surface, "", listener);
    }

    public void stopVideoStream(AbstractCommandListener listener) {
        this.stopVideoStream("", listener);
    }

    public void stopVideoStream(final String tag, final AbstractCommandListener listener) {
        this.capabilityChecker.checkFeatureSupport("feature_solo_video_streaming", new CapabilityApi.FeatureSupportListener(){

            @Override
            public void onFeatureSupportResult(String featureId, int result, Bundle resultInfo) {
                switch (result) {
                    case 0: {
                        SoloCameraApi.this.cameraApi.stopVideoStream(tag, listener);
                        break;
                    }
                    case 1: {
                        SoloCameraApi.postErrorEvent(3, listener);
                        break;
                    }
                    default: {
                        SoloCameraApi.postErrorEvent(4, listener);
                    }
                }
            }
        });
    }

    public void switchCameraCaptureMode(byte captureMode, AbstractCommandListener listener) {
        SoloGoproSetRequest captureModeRequest = new SoloGoproSetRequest(1, captureMode);
        this.sendMessage(captureModeRequest, listener);
    }

    private void sendExtendedRequest(AbstractCommandListener listener, int command, byte value1, byte value2, byte value3, byte value4) {
        byte[] values = new byte[]{value1, value2, value3, value4};
        SoloGoproSetExtendedRequest extendedRequest = new SoloGoproSetExtendedRequest((short)command, values);
        this.sendMessage(extendedRequest, listener);
    }

    private void sendExtendedRequest(AbstractCommandListener listener, int command, byte value) {
        this.sendExtendedRequest(listener, command, value, (byte)0, (byte)0, (byte)0);
    }

    public void updateVideoSettings(byte resolution, byte frameRate, byte fieldOfView, byte flags, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 5, resolution, frameRate, fieldOfView, flags);
    }

    public void setCameraPhotoResolution(byte photoResolution, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 7, photoResolution);
    }

    public void enableCameraLowLight(boolean enable, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 6, enable ? (byte)1 : 0);
    }

    public void setCameraPhotoBurstRate(byte burstRate, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 8, burstRate);
    }

    public void enableCameraProtune(boolean enable, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 9, enable ? (byte)1 : 0);
    }

    public void setCameraProtuneWhiteBalance(byte whiteBalance, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 10, whiteBalance);
    }

    public void setCameraProtuneColour(byte colour, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 11, colour);
    }

    public void setCameraProtuneGain(byte gain, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 12, gain);
    }

    public void setCameraProtuneSharpness(byte sharpness, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 13, sharpness);
    }

    public void setCameraProtuneExposure(byte exposure, AbstractCommandListener listener) {
        this.sendExtendedRequest(listener, 14, exposure);
    }
}

