/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client.apis;

import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import com.o3dr.android.client.Drone;
import com.o3dr.android.client.apis.Api;
import com.o3dr.services.android.lib.model.AbstractCommandListener;
import com.o3dr.services.android.lib.model.action.Action;
import java.util.concurrent.ConcurrentHashMap;

public class CapabilityApi
extends Api {
    public static final int FEATURE_ERROR_DRONE_DISCONNECTED = -1;
    public static final int FEATURE_SUPPORTED = 0;
    public static final int FEATURE_UNSUPPORTED = 1;
    private static final ConcurrentHashMap<Drone, CapabilityApi> capabilityApiCache = new ConcurrentHashMap();
    private static final Api.Builder<CapabilityApi> apiBuilder = new Api.Builder<CapabilityApi>(){

        @Override
        public CapabilityApi build(Drone drone) {
            return new CapabilityApi(drone);
        }
    };
    private final Drone drone;

    public static CapabilityApi getApi(Drone drone) {
        return CapabilityApi.getApi(drone, capabilityApiCache, apiBuilder);
    }

    private CapabilityApi(Drone drone) {
        this.drone = drone;
    }

    public void checkFeatureSupport(final String featureId, final FeatureSupportListener resultListener) {
        if (TextUtils.isEmpty((CharSequence)featureId) || resultListener == null) {
            return;
        }
        if (!this.drone.isConnected()) {
            this.drone.post(new Runnable(){

                @Override
                public void run() {
                    resultListener.onFeatureSupportResult(featureId, -1, null);
                }
            });
            return;
        }
        switch (featureId) {
            case "feature_imu_calibration": {
                this.drone.post(new Runnable(){

                    @Override
                    public void run() {
                        resultListener.onFeatureSupportResult(featureId, 0, null);
                    }
                });
                break;
            }
            case "feature_solo_video_streaming": {
                if (Build.VERSION.SDK_INT < 18) {
                    this.drone.post(new Runnable(){

                        @Override
                        public void run() {
                            resultListener.onFeatureSupportResult(featureId, 1, null);
                        }
                    });
                    break;
                }
            }
            case "feature_compass_calibration": 
            case "feature_kill_switch": {
                Bundle params = new Bundle();
                params.putString("extra_feature_id", featureId);
                this.drone.performAsyncActionOnDroneThread(new Action("com.o3dr.services.android.action.CHECK_FEATURE_SUPPORT", params), new AbstractCommandListener(){

                    @Override
                    public void onSuccess() {
                        resultListener.onFeatureSupportResult(featureId, 0, null);
                    }

                    @Override
                    public void onError(int executionError) {
                        resultListener.onFeatureSupportResult(featureId, 1, null);
                    }

                    @Override
                    public void onTimeout() {
                        resultListener.onFeatureSupportResult(featureId, 1, null);
                    }
                });
                break;
            }
            default: {
                this.drone.post(new Runnable(){

                    @Override
                    public void run() {
                        resultListener.onFeatureSupportResult(featureId, 1, null);
                    }
                });
            }
        }
    }

    public static interface FeatureSupportListener {
        public void onFeatureSupportResult(String var1, int var2, Bundle var3);
    }

    public static final class FeatureIds {
        public static final String SOLO_VIDEO_STREAMING = "feature_solo_video_streaming";
        public static final String COMPASS_CALIBRATION = "feature_compass_calibration";
        public static final String IMU_CALIBRATION = "feature_imu_calibration";
        public static final String KILL_SWITCH = "feature_kill_switch";

        private FeatureIds() {
        }
    }
}

