/*
 * Decompiled with CFR 0.152.
 */
package com.o3dr.android.client;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.o3dr.services.android.lib.model.IDroidPlannerServices;
import com.o3dr.services.android.lib.util.version.VersionUtils;
import java.util.List;
import org.droidplanner.services.android.impl.api.DroidPlannerService;

class ApiAvailability {
    private static final String SERVICES_CLAZZ_NAME = IDroidPlannerServices.class.getName();
    private static final String METADATA_KEY = "com.o3dr.dronekit.android.core.version";
    private static final int INVALID_LIB_VERSION = -1;

    private ApiAvailability() {
    }

    static ApiAvailability getInstance() {
        return LazyHolder.INSTANCE;
    }

    Intent getAvailableServicesInstance(@NonNull Context context) {
        Intent serviceIntent;
        PackageManager pm = context.getPackageManager();
        List serviceInfos = pm.queryIntentServices(serviceIntent = new Intent(SERVICES_CLAZZ_NAME), 128);
        if (serviceInfos != null && !serviceInfos.isEmpty()) {
            for (ResolveInfo serviceInfo : serviceInfos) {
                int coreLibVersion;
                Bundle metaData = serviceInfo.serviceInfo.metaData;
                if (metaData == null || (coreLibVersion = metaData.getInt(METADATA_KEY, -1)) == -1 || coreLibVersion < VersionUtils.getCoreLibVersion(context)) continue;
                serviceIntent.setClassName(serviceInfo.serviceInfo.packageName, serviceInfo.serviceInfo.name);
                return serviceIntent;
            }
        }
        DroidPlannerService.enableDroidPlannerService(context, true);
        serviceIntent.setClass(context, DroidPlannerService.class);
        return serviceIntent;
    }

    private static class LazyHolder {
        private static final ApiAvailability INSTANCE = new ApiAvailability();

        private LazyHolder() {
        }
    }
}

