/*
 * Decompiled with CFR 0.152.
 */
package com.MAVLink.Messages;

import com.MAVLink.MAVLinkPacket;

public class MAVLinkStats {
    public int receivedPacketCount;
    public int crcErrorCount;
    public int lostPacketCount;
    private int lastPacketSeq;

    public void newPacket(MAVLinkPacket packet) {
        this.advanceLastPacketSequence();
        if (this.hasLostPackets(packet)) {
            this.updateLostPacketCount(packet);
        }
        this.lastPacketSeq = packet.seq;
        ++this.receivedPacketCount;
    }

    private void updateLostPacketCount(MAVLinkPacket packet) {
        int lostPackets = packet.seq - this.lastPacketSeq < 0 ? packet.seq - this.lastPacketSeq + 255 : packet.seq - this.lastPacketSeq;
        this.lostPacketCount += lostPackets;
    }

    private boolean hasLostPackets(MAVLinkPacket packet) {
        return this.lastPacketSeq > 0 && packet.seq != this.lastPacketSeq;
    }

    private void advanceLastPacketSequence() {
        this.lastPacketSeq = this.lastPacketSeq + 1 & 0xFF;
    }

    public void crcError() {
        ++this.crcErrorCount;
    }

    public void mavlinkResetStats() {
        this.lastPacketSeq = -1;
        this.lostPacketCount = 0;
        this.crcErrorCount = 0;
        this.receivedPacketCount = 0;
    }
}

