/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.utils;

import android.text.TextUtils;
import com.o3dr.services.android.lib.drone.attribute.error.ErrorType;
import java.util.Locale;
import org.droidplanner.services.android.impl.core.drone.autopilot.MavLinkDrone;
import org.droidplanner.services.android.impl.core.model.AutopilotWarningParser;

public class AndroidApWarningParser
implements AutopilotWarningParser {
    @Override
    public String getDefaultWarning() {
        return ErrorType.NO_ERROR.name();
    }

    @Override
    public String parseWarning(MavLinkDrone drone, String warning) {
        if (TextUtils.isEmpty((CharSequence)warning)) {
            return null;
        }
        ErrorType errorType = this.getErrorType(warning);
        if (errorType == null) {
            return null;
        }
        return errorType.name();
    }

    private ErrorType getErrorType(String warning) {
        switch (warning.toLowerCase(Locale.US)) {
            case "arm: thr below fs": 
            case "arm: throttle below failsafe": {
                return ErrorType.ARM_THROTTLE_BELOW_FAILSAFE;
            }
            case "arm: gyro calibration failed": {
                return ErrorType.ARM_GYRO_CALIBRATION_FAILED;
            }
            case "arm: mode not armable": {
                return ErrorType.ARM_MODE_NOT_ARMABLE;
            }
            case "arm: rotor not spinning": {
                return ErrorType.ARM_ROTOR_NOT_SPINNING;
            }
            case "arm: altitude disparity": 
            case "prearm: altitude disparity": {
                return ErrorType.ALTITUDE_DISPARITY;
            }
            case "arm: leaning": {
                return ErrorType.ARM_LEANING;
            }
            case "arm: throttle too high": {
                return ErrorType.ARM_THROTTLE_TOO_HIGH;
            }
            case "arm: safety switch": {
                return ErrorType.ARM_SAFETY_SWITCH;
            }
            case "arm: compass calibration running": {
                return ErrorType.ARM_COMPASS_CALIBRATION_RUNNING;
            }
            case "prearm: rc not calibrated": {
                return ErrorType.PRE_ARM_RC_NOT_CALIBRATED;
            }
            case "prearm: barometer not healthy": {
                return ErrorType.PRE_ARM_BAROMETER_NOT_HEALTHY;
            }
            case "prearm: compass not healthy": {
                return ErrorType.PRE_ARM_COMPASS_NOT_HEALTHY;
            }
            case "prearm: compass not calibrated": {
                return ErrorType.PRE_ARM_COMPASS_NOT_CALIBRATED;
            }
            case "prearm: compass offsets too high": {
                return ErrorType.PRE_ARM_COMPASS_OFFSETS_TOO_HIGH;
            }
            case "prearm: check mag field": {
                return ErrorType.PRE_ARM_CHECK_MAGNETIC_FIELD;
            }
            case "prearm: inconsistent compasses": {
                return ErrorType.PRE_ARM_INCONSISTENT_COMPASSES;
            }
            case "prearm: check fence": {
                return ErrorType.PRE_ARM_CHECK_FENCE;
            }
            case "prearm: ins not calibrated": {
                return ErrorType.PRE_ARM_INS_NOT_CALIBRATED;
            }
            case "prearm: accelerometers not healthy": {
                return ErrorType.PRE_ARM_ACCELEROMETERS_NOT_HEALTHY;
            }
            case "prearm: inconsistent accelerometers": {
                return ErrorType.PRE_ARM_INCONSISTENT_ACCELEROMETERS;
            }
            case "prearm: gyros not healthy": {
                return ErrorType.PRE_ARM_GYROS_NOT_HEALTHY;
            }
            case "prearm: inconsistent gyros": {
                return ErrorType.PRE_ARM_INCONSISTENT_GYROS;
            }
            case "prearm: check board voltage": {
                return ErrorType.PRE_ARM_CHECK_BOARD_VOLTAGE;
            }
            case "prearm: duplicate aux switch options": {
                return ErrorType.PRE_ARM_DUPLICATE_AUX_SWITCH_OPTIONS;
            }
            case "prearm: check fs_thr_value": {
                return ErrorType.PRE_ARM_CHECK_FAILSAFE_THRESHOLD_VALUE;
            }
            case "prearm: check angle_max": {
                return ErrorType.PRE_ARM_CHECK_ANGLE_MAX;
            }
            case "prearm: acro_bal_roll/pitch": {
                return ErrorType.PRE_ARM_ACRO_BAL_ROLL_PITCH;
            }
            case "prearm: need 3d fix": {
                return ErrorType.PRE_ARM_NEED_GPS_LOCK;
            }
            case "prearm: ekf-home variance": {
                return ErrorType.PRE_ARM_EKF_HOME_VARIANCE;
            }
            case "prearm: high gps hdop": {
                return ErrorType.PRE_ARM_HIGH_GPS_HDOP;
            }
            case "prearm: gps glitch": 
            case "prearm: bad velocity": {
                return ErrorType.PRE_ARM_GPS_GLITCH;
            }
            case "prearm: waiting for navigation alignment": 
            case "arm: waiting for navigation alignment": {
                return ErrorType.WAITING_FOR_NAVIGATION_ALIGNMENT;
            }
            case "no dataflash inserted": {
                return ErrorType.NO_DATAFLASH_INSERTED;
            }
            case "low battery!": {
                return ErrorType.LOW_BATTERY;
            }
            case "autotune: failed": {
                return ErrorType.AUTO_TUNE_FAILED;
            }
            case "crash: disarming": {
                return ErrorType.CRASH_DISARMING;
            }
            case "parachute: too low": {
                return ErrorType.PARACHUTE_TOO_LOW;
            }
            case "ekf variance": {
                return ErrorType.EKF_VARIANCE;
            }
            case "rc failsafe": {
                return ErrorType.RC_FAILSAFE;
            }
        }
        return null;
    }
}

