/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.mission.commands;

import com.MAVLink.common.msg_mission_item;
import java.util.List;
import org.droidplanner.services.android.impl.core.mission.MissionImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemImpl;
import org.droidplanner.services.android.impl.core.mission.MissionItemType;
import org.droidplanner.services.android.impl.core.mission.commands.MissionCMD;

public class TakeoffImpl
extends MissionCMD {
    public static final double DEFAULT_TAKEOFF_ALTITUDE = 10.0;
    private double finishedAlt = 10.0;
    private double pitch = 0.0;

    public TakeoffImpl(MissionItemImpl item) {
        super(item);
    }

    public TakeoffImpl(msg_mission_item msg, MissionImpl missionImpl) {
        super(missionImpl);
        this.unpackMAVMessage(msg);
    }

    public TakeoffImpl(MissionImpl missionImpl, double altitude) {
        super(missionImpl);
        this.finishedAlt = altitude;
        this.pitch = 0.0;
    }

    public TakeoffImpl(MissionImpl missionImpl, double altitude, double pitch) {
        super(missionImpl);
        this.finishedAlt = altitude;
        this.pitch = pitch;
    }

    @Override
    public List<msg_mission_item> packMissionItem() {
        List<msg_mission_item> list = super.packMissionItem();
        msg_mission_item mavMsg = list.get(0);
        mavMsg.command = 22;
        mavMsg.frame = (short)3;
        mavMsg.z = (float)this.finishedAlt;
        if (this.pitch > 0.0) {
            mavMsg.param1 = (float)this.pitch;
        }
        return list;
    }

    @Override
    public void unpackMAVMessage(msg_mission_item mavMsg) {
        this.finishedAlt = mavMsg.z;
        this.pitch = mavMsg.param1;
    }

    @Override
    public MissionItemType getType() {
        return MissionItemType.TAKEOFF;
    }

    public double getFinishedAlt() {
        return this.finishedAlt;
    }

    public void setFinishedAlt(double finishedAlt) {
        this.finishedAlt = finishedAlt;
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setPitch(double pitch) {
        this.pitch = pitch;
    }
}

