/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.location;

import com.o3dr.services.android.lib.coordinate.LatLongAlt;

public class Location {
    private LatLongAlt coordinate;
    private double heading = 0.0;
    private double speed = 0.0;
    private boolean isAccurate;
    private long fixTime;

    public Location(LatLongAlt coord3d, float heading, float speed, boolean isAccurate, long fixTime) {
        this.coordinate = coord3d;
        this.heading = heading;
        this.speed = speed;
        this.isAccurate = isAccurate;
        this.fixTime = fixTime;
    }

    public LatLongAlt getCoord() {
        return this.coordinate;
    }

    public boolean isAccurate() {
        return !this.isInvalid() && this.isAccurate;
    }

    private boolean isInvalid() {
        return this.coordinate == null || this.coordinate.getLatitude() == 0.0 && this.coordinate.getLongitude() == 0.0;
    }

    public double getBearing() {
        return this.heading;
    }

    public double getSpeed() {
        return this.speed;
    }

    public long getFixTime() {
        return this.fixTime;
    }

    public static interface LocationFinder {
        public void enableLocationUpdates(String var1, LocationReceiver var2);

        public void disableLocationUpdates(String var1);
    }

    public static interface LocationReceiver {
        public void onLocationUpdate(Location var1);

        public void onLocationUnavailable();
    }
}

