/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.location;

import android.content.Context;
import android.os.Handler;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.location.LocationAvailability;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.o3dr.services.android.lib.util.googleApi.GoogleApiClientManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.droidplanner.services.android.impl.core.gcs.follow.LocationRelay;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import timber.log.Timber;

public class FusedLocation
extends LocationCallback
implements Location.LocationFinder,
GoogleApiClientManager.ManagerListener {
    private static final String TAG = FusedLocation.class.getSimpleName();
    private static final long MIN_TIME_MS = 16L;
    private static final float MIN_DISTANCE_M = 0.0f;
    private static final Api<? extends Api.ApiOptions.NotRequiredOptions>[] apisList = new Api[]{LocationServices.API};
    private final GoogleApiClientManager gApiMgr;
    private final GoogleApiClientManager.GoogleApiClientTask requestLocationUpdate;
    private boolean mLocationUpdatesEnabled = false;
    private final GoogleApiClientManager.GoogleApiClientTask removeLocationUpdate = new GoogleApiClientManager.GoogleApiClientTask(){

        @Override
        protected void doRun() {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.getGoogleApiClient(), (LocationCallback)FusedLocation.this);
        }
    };
    private final Map<String, Location.LocationReceiver> receivers = new ConcurrentHashMap<String, Location.LocationReceiver>();
    private final LocationRelay locationRelay;
    private final Context context;

    public FusedLocation(Context context, Handler handler) {
        this(context, handler, 100, 16L, 16L, 0.0f);
    }

    public FusedLocation(Context context, final Handler handler, final int locationRequestPriority, final long interval, final long fastestInterval, final float smallestDisplacement) {
        this.context = context;
        this.locationRelay = new LocationRelay();
        this.requestLocationUpdate = new GoogleApiClientManager.GoogleApiClientTask(){

            @Override
            protected void doRun() {
                LocationRequest locationRequest = LocationRequest.create();
                locationRequest.setPriority(locationRequestPriority);
                locationRequest.setInterval(interval);
                locationRequest.setFastestInterval(fastestInterval);
                locationRequest.setSmallestDisplacement(smallestDisplacement);
                LocationServices.FusedLocationApi.requestLocationUpdates(this.getGoogleApiClient(), locationRequest, (LocationCallback)FusedLocation.this, handler.getLooper());
            }
        };
        this.gApiMgr = new GoogleApiClientManager(context, handler, apisList);
        this.gApiMgr.setManagerListener(this);
    }

    @Override
    public void enableLocationUpdates(String tag, Location.LocationReceiver receiver) {
        this.receivers.put(tag, receiver);
        if (!this.mLocationUpdatesEnabled) {
            this.gApiMgr.start();
            this.locationRelay.onFollowStart();
            this.mLocationUpdatesEnabled = true;
        }
    }

    @Override
    public void disableLocationUpdates(String tag) {
        if (this.mLocationUpdatesEnabled) {
            this.gApiMgr.addTask(this.removeLocationUpdate);
            this.gApiMgr.stopSafely();
            this.mLocationUpdatesEnabled = false;
        }
        this.receivers.remove(tag);
    }

    public void onLocationAvailability(LocationAvailability locationAvailability) {
        super.onLocationAvailability(locationAvailability);
    }

    public void onLocationResult(LocationResult result) {
        android.location.Location androidLocation = result.getLastLocation();
        if (androidLocation == null) {
            return;
        }
        Location gcsLocation = this.locationRelay.toGcsLocation(androidLocation);
        if (gcsLocation == null) {
            return;
        }
        Timber.d((String)("Location Lat/Long: " + LocationRelay.getLatLongFromLocation(androidLocation)), (Object[])new Object[0]);
        this.notifyLocationUpdate(gcsLocation);
    }

    private void notifyLocationUpdate(Location location) {
        if (this.receivers.isEmpty()) {
            Timber.d((String)TAG, (Object[])new Object[]{"notifyLocationUpdate(): No receivers"});
            return;
        }
        for (Location.LocationReceiver receiver : this.receivers.values()) {
            receiver.onLocationUpdate(location);
        }
    }

    @Override
    public void onGoogleApiConnectionError(ConnectionResult result) {
        this.notifyLocationUnavailable();
        GooglePlayServicesUtil.showErrorNotification((int)result.getErrorCode(), (Context)this.context);
    }

    @Override
    public void onUnavailableGooglePlayServices(int status) {
        this.notifyLocationUnavailable();
        GooglePlayServicesUtil.showErrorNotification((int)status, (Context)this.context);
    }

    private void notifyLocationUnavailable() {
        if (this.receivers.isEmpty()) {
            return;
        }
        for (Location.LocationReceiver listener : this.receivers.values()) {
            listener.onLocationUnavailable();
        }
    }

    @Override
    public void onManagerStarted() {
        this.gApiMgr.addTask(this.requestLocationUpdate);
    }

    @Override
    public void onManagerStopped() {
    }
}

