/*
 * Decompiled with CFR 0.152.
 */
package org.droidplanner.services.android.impl.core.gcs.follow;

import com.o3dr.services.android.lib.coordinate.LatLong;
import com.o3dr.services.android.lib.coordinate.LatLongAlt;
import org.droidplanner.services.android.impl.core.gcs.location.Location;
import org.droidplanner.services.android.impl.core.helpers.geoTools.GeoTools;
import timber.log.Timber;

public class LocationRelay {
    static final String TAG = LocationRelay.class.getSimpleName();
    private static final float LOCATION_ACCURACY_THRESHOLD = 10.0f;
    private static final float JUMP_FACTOR = 4.0f;
    private static boolean VERBOSE = false;
    private android.location.Location mLastLocation;
    private float mTotalSpeed = 0.0f;
    private int mSpeedReadings = 0;

    public static String getLatLongFromLocation(android.location.Location location) {
        return android.location.Location.convert((double)location.getLatitude(), (int)0) + " " + android.location.Location.convert((double)location.getLongitude(), (int)0);
    }

    public void onFollowStart() {
        this.mTotalSpeed = 0.0f;
        this.mSpeedReadings = 0;
        this.mLastLocation = null;
    }

    public Location toGcsLocation(android.location.Location androidLocation) {
        boolean ok;
        if (androidLocation == null) {
            return null;
        }
        Location gcsLocation = null;
        if (VERBOSE) {
            Timber.d((String)("toGcsLocation(): followLoc=" + androidLocation), (Object[])new Object[0]);
        }
        if (!androidLocation.hasBearing()) {
            if (this.mLastLocation != null) {
                LatLong last = new LatLong(this.mLastLocation.getLatitude(), this.mLastLocation.getLongitude());
                LatLong newLoc = new LatLong(androidLocation.getLatitude(), androidLocation.getLongitude());
                androidLocation.setBearing((float)GeoTools.getHeadingFromCoordinates(last, newLoc));
            } else {
                androidLocation.setBearing(0.0f);
            }
        }
        boolean bl = ok = androidLocation.hasAccuracy() && androidLocation.hasBearing() && androidLocation.getTime() > 0L;
        if (!ok) {
            Timber.w((String)"toGcsLocation(): Location needs accuracy, bearing, and time.", (Object[])new Object[0]);
        } else {
            float distanceToLast = -1.0f;
            long timeSinceLast = -1L;
            long androidLocationTime = androidLocation.getTime();
            if (this.mLastLocation != null) {
                distanceToLast = androidLocation.distanceTo(this.mLastLocation);
                timeSinceLast = androidLocationTime - this.mLastLocation.getTime();
            }
            float currentSpeed = distanceToLast > 0.0f && timeSinceLast > 0L ? distanceToLast * 1000.0f / (float)timeSinceLast : 0.0f;
            boolean isAccurate = this.isLocationAccurate(androidLocation.getAccuracy(), currentSpeed);
            if (VERBOSE) {
                Timber.d((String)"toLocation(): distancetoLast=%.2f timeToLast=%d currSpeed=%.2f accurate=%s", (Object[])new Object[]{Float.valueOf(distanceToLast), timeSinceLast, Float.valueOf(currentSpeed), isAccurate});
            }
            gcsLocation = new Location(new LatLongAlt(androidLocation.getLatitude(), androidLocation.getLongitude(), androidLocation.getAltitude()), androidLocation.getBearing(), androidLocation.getSpeed(), isAccurate, androidLocation.getTime());
            this.mLastLocation = androidLocation;
            if (VERBOSE) {
                Timber.d((String)("External location lat/lng=" + LocationRelay.getLatLongFromLocation(androidLocation)), (Object[])new Object[0]);
            }
        }
        return gcsLocation;
    }

    private boolean isLocationAccurate(float accuracy, float currentSpeed) {
        if (accuracy >= 10.0f) {
            Timber.w((String)("isLocationAccurate() -- High/bad accuracy: " + accuracy), (Object[])new Object[0]);
            return false;
        }
        this.mTotalSpeed += currentSpeed;
        float avg = this.mTotalSpeed / (float)(++this.mSpeedReadings);
        if (currentSpeed > 0.0f && (double)avg >= 1.0 && currentSpeed >= avg * 4.0f) {
            Timber.w((String)("isLocationAccurate() -- High current speed: " + currentSpeed), (Object[])new Object[0]);
            return false;
        }
        return true;
    }
}

